/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.core.guid;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.sds.adapter.ScheduleAdapter;
import com.cognos.sds.core.persist.PublishedGuidException;
import com.cognos.sds.core.persist.PublishedGuidPersist;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import java.sql.Connection;

public class PublishedGuidPersistHandler
implements ProcessHandler {
    public static PublishedGuidPersistHandler instance = new PublishedGuidPersistHandler();

    private PublishedGuidPersistHandler() {
    }

    public static PublishedGuidPersistHandler getInstance() {
        return instance;
    }

    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        ScheduleAdapter adapter = context.getScheduleAdapter();
        JDBCConnection connection = context.getConnection();
        NCObjectId taskId = context.getTask().getNCObjectId();
        String guid = null;
        try {
            guid = adapter.getTaskID() != null && !"".equals(adapter.getTaskID()) ? PublishedGuidPersist.getInstance().publishGuid((Connection)connection, adapter.getTaskID(), taskId, context.getTaskType()) : PublishedGuidPersist.getInstance().publishGuid((Connection)connection, taskId, context.getTaskType());
        }
        catch (PublishedGuidException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.INFO, (LocalizableException)((Object)ex));
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.GUID_CREATE_ERROR, (Object[])new String[]{taskId.toString()});
            throw new ProcessHandlerException(I18NCode.GUID_CREATE_ERROR, new Object[]{taskId}, (LocalizableException)((Object)ex));
        }
        adapter.setTaskID(guid);
    }
}

