/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.core.persist;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jdbc.AbstractFactory;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.sds.handler.IChainHandler;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ConnectionHandler
implements IChainHandler {
    private List m_handlers = new ArrayList();

    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        JDBCConnection connection = null;
        AbstractFactory cf = null;
        try {
            cf = NCConnection.instance().getConnectionFactory();
            connection = cf.createConnection();
            context.setConnection(connection);
            Iterator iter = this.m_handlers.iterator();
            while (iter.hasNext()) {
                ((ProcessHandler)iter.next()).invoke(context);
            }
        }
        catch (SQLException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).debug("ConnectionHandler.invoke exception: " + ex.getLocalizedMessage());
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SCHDR_TRANSACTION_FAILURE);
            throw new ProcessHandlerException(I18NCode.SCHDR_TRANSACTION_FAILURE);
        }
        finally {
            if (connection != null) {
                try {
                    if (cf != null) {
                        cf.releaseConnection(connection);
                        context.removeConnection();
                    }
                }
                catch (SQLException e) {
                    AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                    SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_RELEASE_ERROR, (Map)ap);
                    throw new ProcessHandlerException(I18NCode.SQL_RELEASE_ERROR);
                }
            }
        }
    }

    @Override
    public void add(ProcessHandler handler) {
        this.m_handlers.add(handler);
    }

    @Override
    public void set(List handlers) {
        this.m_handlers = handlers;
    }
}

