/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.core.persist;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.sds.core.persist.ObjectPersistException;
import java.sql.Connection;
import noticecast.datatier.helperoptions.HelperOption;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.base.INCBaseObjectConsumer;
import noticecast.logictier.base.INCFeatherWeight;
import noticecast.persist.INCObjectUpdate;
import noticecast.persist.IPersistManager;
import noticecast.persist.PersistManagerException;
import noticecast.persist.StoreObjectException;
import noticecast.services.RepositoryServicesImpl;

public class ObjectPersist {
    private static ObjectPersist instance = new ObjectPersist();

    private ObjectPersist() {
    }

    public static ObjectPersist getInstance() {
        return instance;
    }

    public void storeNew(Connection connection, INCBaseObjectConsumer object, NCObjectType type, NCObjectType subType) throws ObjectPersistException {
        try {
            IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
            pm.storeNew(object, type, subType, connection, null);
        }
        catch (StoreObjectException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.FATAL, I18NCode.MSG_OBJ_STORE_EXCP, (Object[])new String[]{type.toString(), " "});
            throw new ObjectPersistException(I18NCode.PERST_UNABLE_STORE_OBJECT, new Object[]{type}, ex);
        }
    }

    public void update(Connection connection, INCObjectUpdate update) throws ObjectPersistException {
        try {
            IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
            pm.store(connection, update, null);
        }
        catch (PersistManagerException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.FATAL, I18NCode.MSG_REPOSITORY_UPDATE_GENERAL_FAIL, (Object[])new String[]{ex.getMessage() + ""});
            NCObjectType type = NCObjectType.UNKNOWN;
            type = update.getObjectType();
            throw new ObjectPersistException(I18NCode.PERST_UNABLE_UPDATE_OBJECT, new Object[]{type}, ex);
        }
    }

    public void delete(Connection connection, NCObjectId id, NCObjectType type) throws ObjectPersistException {
        try {
            IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
            pm.delete(id, type, null, connection);
        }
        catch (PersistManagerException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.FATAL, I18NCode.MSG_OBJ_DEL_EXCP, (Object[])new String[]{type.toString(), id.toString()});
            throw new ObjectPersistException(I18NCode.PERST_UNABLE_DELETE_OBJECT, new Object[]{type}, ex);
        }
    }

    public INCFeatherWeight[] getNCFeatherWeightList(NCObjectType type, HelperOption option) throws ObjectPersistException {
        INCFeatherWeight[] ncFws = null;
        try {
            IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
            ncFws = option == null ? pm.getFeatherWeightList(type) : pm.getFeatherWeightList(type, option);
        }
        catch (PersistManagerException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.FATAL, I18NCode.MSG_OBJ_NOTFOUND_EXCP, (Object[])new String[]{type.toString(), "?"});
            throw new ObjectPersistException(I18NCode.PERST_UNABLE_RETRIEVE_OBJECT, new Object[]{type}, ex);
        }
        return ncFws;
    }

    public INCFeatherWeight getNCFeatherWeight(NCObjectId ncId) throws ObjectPersistException {
        INCFeatherWeight ncFw = null;
        try {
            IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
            ncFw = pm.getFeatherWeight(ncId);
        }
        catch (PersistManagerException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.FATAL, I18NCode.MSG_OBJ_NOTFOUND_EXCP, (Object[])new String[]{ncFw.getName(), ncId.toString()});
            throw new ObjectPersistException(I18NCode.PERST_UNABLE_RETRIEVE_OBJECT, new Object[]{NCObjectType.UNKNOWN}, ex);
        }
        return ncFw;
    }

    public INCObjectUpdate getNCObjectUpdate(NCObjectType type, NCObjectId ncId) throws ObjectPersistException {
        INCObjectUpdate ncUpd = null;
        try {
            IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
            ncUpd = pm.findNCObjectUpdateByOid(ncId, type, null);
        }
        catch (PersistManagerException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.FATAL, I18NCode.MSG_OBJ_NOTFOUND_EXCP, (Object[])new String[]{type.toString(), ncId.toString()});
            throw new ObjectPersistException(I18NCode.PERST_UNABLE_RETRIEVE_OBJECT, new Object[]{type}, ex);
        }
        return ncUpd;
    }

    public INCObjectUpdate[] getNCObjectUpdates(NCObjectType type, HelperOption helperOption) throws ObjectPersistException {
        INCObjectUpdate[] ncUpds = null;
        try {
            IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
            ncUpds = pm.findNCObjectUpdateByHelperOption(type, helperOption);
        }
        catch (PersistManagerException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.FATAL, I18NCode.MSG_OBJ_NOTFOUND_EXCP, (Object[])new String[]{type.toString(), " "});
            throw new ObjectPersistException(I18NCode.PERST_UNABLE_RETRIEVE_OBJECT, new Object[]{type}, ex);
        }
        return ncUpds;
    }
}

