/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.core.persist;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.GuidIdGenerator;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.sds.core.persist.PublishedGuidException;
import java.sql.Connection;
import noticecast.datatier.DTException;
import noticecast.datatier.guid.IJDBCGuid;
import noticecast.datatier.guid.JDBCGuidImpl;
import noticecast.logictier.NCObjectType;

public class PublishedGuidPersist {
    private static PublishedGuidPersist instance = new PublishedGuidPersist();
    private IJDBCGuid guidDataHelper = new JDBCGuidImpl();

    private PublishedGuidPersist() {
    }

    public static PublishedGuidPersist getInstance() {
        return instance;
    }

    public NCObjectId getNCObjectId(Connection connection, String guid) throws PublishedGuidException {
        NCObjectId ncId = null;
        try {
            ncId = this.guidDataHelper.getNCObjectId(connection, guid);
        }
        catch (DTException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex);
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.GUID_ERROR_RETRIEVE_LINK, (Object[])new String[]{guid});
            throw new PublishedGuidException(I18NCode.GUID_ERROR_RETRIEVE_LINK, new Object[]{guid}, ex);
        }
        if (ncId == null) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.GUID_NO_LINK_ERROR, (Object[])new String[]{guid});
            throw new PublishedGuidException(I18NCode.GUID_NO_LINK_ERROR, new Object[]{guid});
        }
        return ncId;
    }

    public NCObjectId[] getNCObjectIds(Connection connection, String[] guids) throws PublishedGuidException {
        NCObjectId[] ids = null;
        try {
            ids = this.guidDataHelper.getNCObjectIds(connection, guids);
        }
        catch (DTException e) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)e);
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.GUID_UNABLE_CREATE_LINK);
            throw new PublishedGuidException(I18NCode.GUID_UNABLE_CREATE_LINK, e);
        }
        return ids;
    }

    public NCObjectId getNCObjectId(String guid) throws PublishedGuidException {
        NCObjectId id = null;
        try {
            id = this.guidDataHelper.getNCObjectId(guid);
        }
        catch (DTException e) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)e);
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.IO_UNABLE_CONNECT_CM);
            throw new PublishedGuidException(I18NCode.IO_UNABLE_CONNECT_CM, e);
        }
        return id;
    }

    public String getGuid(Connection connection, NCObjectId ncId) throws PublishedGuidException {
        String guid = null;
        try {
            guid = this.guidDataHelper.getGuid(connection, ncId);
        }
        catch (DTException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex);
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.GUID_ERROR_RETRIEVE_LINK, (Object[])new String[]{ncId.toString()});
            throw new PublishedGuidException(I18NCode.GUID_ERROR_RETRIEVE_LINK, new Object[]{ncId}, ex);
        }
        if (guid == null) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.GUID_ERROR_RETRIEVE_LINK, (Object[])new String[]{"id is null"});
            throw new PublishedGuidException(I18NCode.GUID_ERROR_RETRIEVE_LINK);
        }
        return guid;
    }

    public String getGuid(Connection connection, NCObjectId ncId, NCObjectType type) throws PublishedGuidException {
        String guid = null;
        try {
            guid = type != null ? this.guidDataHelper.getGuid(connection, ncId, type) : this.guidDataHelper.getGuid(connection, ncId);
        }
        catch (DTException ex) {
            throw new PublishedGuidException(I18NCode.GUID_ERROR_RETRIEVE_LINK, new Object[]{ncId}, ex);
        }
        return guid;
    }

    public String getGuid(NCObjectId ncId, NCObjectType type) throws PublishedGuidException {
        String guid = null;
        try {
            guid = this.guidDataHelper.getGuid(ncId, type);
        }
        catch (DTException e) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)e);
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.GUID_ERROR_RETRIEVE_LINK, (Object[])new String[]{ncId.toString()});
            throw new PublishedGuidException(I18NCode.GUID_ERROR_RETRIEVE_LINK, new Object[]{ncId}, e);
        }
        return guid;
    }

    public String publishGuid(Connection connection, String guid, NCObjectId ncId, NCObjectType type) throws PublishedGuidException {
        try {
            this.guidDataHelper.storeNew(connection, guid, ncId, type);
        }
        catch (DTException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex);
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.GUID_UNABLE_CREATE_LINK);
            throw new PublishedGuidException(I18NCode.GUID_UNABLE_CREATE_LINK, ex);
        }
        return guid;
    }

    public String publishGuid(Connection connection, NCObjectId ncId, NCObjectType type) throws PublishedGuidException {
        String guid = GuidIdGenerator.createNew().toString();
        try {
            this.guidDataHelper.storeNew(connection, guid, ncId, type);
        }
        catch (DTException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex);
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.GUID_UNABLE_CREATE_LINK);
            throw new PublishedGuidException(I18NCode.GUID_UNABLE_CREATE_LINK, ex);
        }
        return guid;
    }

    public void deleteGuid(Connection connection, String guid) throws PublishedGuidException {
        try {
            this.guidDataHelper.deleteGuid(connection, guid);
        }
        catch (DTException ex) {
            throw new PublishedGuidException(I18NCode.GUID_UNABLE_DELETE_LINK, ex);
        }
    }
}

