/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.core.persist;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.jdbc.AbstractFactory;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.jdbc.util.JDBCUtils;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.sds.handler.IChainHandler;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TransactionHandler
implements IChainHandler {
    private List m_handlers;
    private boolean m_useContextConnection;

    public TransactionHandler() {
        this(false);
    }

    public TransactionHandler(boolean useContextConnection) {
        this.m_useContextConnection = useContextConnection;
        this.m_handlers = new ArrayList();
    }

    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        boolean commitTransaction = false;
        JDBCConnection connection = null;
        AbstractFactory cf = null;
        try {
            if (this.m_useContextConnection) {
                if (!context.hasConnection()) {
                    SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).debug("TransactionHandler: no connection in context!");
                    SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SCHDR_TRANSACTION_FAILURE);
                    throw new ProcessHandlerException(I18NCode.SCHDR_TRANSACTION_FAILURE);
                }
                connection = context.getConnection();
                connection.setAutoCommit(false);
            } else {
                cf = NCConnection.instance().getConnectionFactory();
                connection = cf.createConnection();
                connection.setAutoCommit(false);
                context.setConnection(connection);
            }
            Iterator iter = this.m_handlers.iterator();
            while (iter.hasNext()) {
                ((ProcessHandler)iter.next()).invoke(context);
            }
            commitTransaction = true;
        }
        catch (SQLException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SCHDR_TRANSACTION_FAILURE);
            throw new ProcessHandlerException(I18NCode.SCHDR_TRANSACTION_FAILURE);
        }
        catch (ProcessHandlerException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)((Object)ex));
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SCHDR_TRANSACTION_FAILURE);
            throw new ProcessHandlerException(I18NCode.SCHDR_TRANSACTION_FAILURE, (LocalizableException)((Object)ex));
        }
        catch (NullPointerException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SCHDR_TRANSACTION_FAILURE);
            throw new ProcessHandlerException(I18NCode.SCHDR_TRANSACTION_FAILURE);
        }
        finally {
            if (connection != null) {
                if (commitTransaction) {
                    try {
                        JDBCUtils.comitTransaction((Connection)connection);
                    }
                    catch (SQLException e) {
                        SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).debug((Throwable)e);
                        SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_COMMIT_ERROR);
                        throw new ProcessHandlerException(I18NCode.SQL_COMMIT_ERROR);
                    }
                }
                try {
                    connection.rollback();
                }
                catch (SQLException e) {
                    AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                    SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_ROLLBACK_ERROR, (Map)ap);
                    throw new ProcessHandlerException(I18NCode.SQL_ROLLBACK_ERROR);
                }
                try {
                    if (cf != null) {
                        cf.releaseConnection(connection);
                        context.removeConnection();
                    }
                }
                catch (SQLException e) {
                    AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                    SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_RELEASE_ERROR, (Map)ap);
                    throw new ProcessHandlerException(I18NCode.SQL_RELEASE_ERROR);
                }
            }
        }
    }

    @Override
    public void add(ProcessHandler handler) {
        this.m_handlers.add(handler);
    }

    @Override
    public void set(List handlers) {
        this.m_handlers = handlers;
    }
}

