/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.core.recipient;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.sds.adapter.ScheduleAdapter;
import com.cognos.sds.api.converter.ConverterException;
import com.cognos.sds.api.converter.recipient.RecipientConverter;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import noticecast.logictier.recipient.IRecipient;

public class RecipientBuildHandler
implements ProcessHandler {
    private static final RecipientBuildHandler instance = new RecipientBuildHandler();

    private RecipientBuildHandler() {
    }

    public static RecipientBuildHandler getInstance() {
        return instance;
    }

    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        ScheduleAdapter adapterObject = context.getScheduleAdapter();
        IRecipient recipient = null;
        try {
            RecipientConverter converter = new RecipientConverter();
            recipient = (IRecipient)converter.createNCObject(adapterObject);
        }
        catch (ConverterException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex);
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.RCPT_CREATE_ERROR);
            throw new ProcessHandlerException(I18NCode.RCPT_CREATE_ERROR, ex);
        }
        context.setRecipient(recipient);
    }
}

