/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.core.recipient;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.sds.core.DatatierRecovery;
import com.cognos.sds.core.persist.ObjectPersist;
import com.cognos.sds.core.persist.ObjectPersistException;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import java.util.Iterator;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.agent.ITask;
import noticecast.logictier.message.IMessageStruct;
import noticecast.logictier.message.IRecipientLink;
import noticecast.persist.INCObjectUpdate;

public class RecipientRetrieveHandler
implements ProcessHandler {
    public static final RecipientRetrieveHandler instance = new RecipientRetrieveHandler();

    private RecipientRetrieveHandler() {
    }

    public static RecipientRetrieveHandler getInstance() {
        return instance;
    }

    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        ITask task = (ITask)context.getTaskUpdate().getObject();
        NCObjectId recipientId = this.getRecipientIdFromTask(task);
        INCObjectUpdate objUp = null;
        try {
            objUp = ObjectPersist.getInstance().getNCObjectUpdate(NCObjectType.RECIPIENT, recipientId);
        }
        catch (ObjectPersistException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)((Object)ex));
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.RCPT_CREATE_ERROR);
            DatatierRecovery.instance().repairTaskAndTaskSchedule(task.getNCObjectId());
            throw new ProcessHandlerException(I18NCode.RCPT_CREATE_ERROR, (LocalizableException)((Object)ex));
        }
        context.setRecipientUpdate(objUp);
    }

    private NCObjectId getRecipientIdFromTask(ITask task) throws ProcessHandlerException {
        Iterator iter = task.getMessages();
        NCObjectId recipientId = null;
        while (iter.hasNext()) {
            IRecipientLink[] links = ((IMessageStruct)iter.next()).getRecipientLinks();
            if (links != null && links.length == 1) {
                recipientId = links[0].getRecipientId();
                continue;
            }
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_THE_RECIPIENT_IS_NULL);
            DatatierRecovery.instance().repairTaskAndTaskSchedule(task.getNCObjectId());
            throw new ProcessHandlerException(I18NCode.MSG_THE_RECIPIENT_IS_NULL);
        }
        return recipientId;
    }
}

