/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.core.recipient;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.sds.adapter.ScheduleAdapter;
import com.cognos.sds.api.converter.ConverterException;
import com.cognos.sds.api.converter.recipient.RecipientConverter;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;

public class RecipientUpdateHandler
implements ProcessHandler {
    private static final RecipientUpdateHandler instance = new RecipientUpdateHandler();

    private RecipientUpdateHandler() {
    }

    public static RecipientUpdateHandler getInstance() {
        return instance;
    }

    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        ScheduleAdapter adapter = context.getScheduleAdapter();
        try {
            RecipientConverter converter = new RecipientConverter();
            converter.updateNCObject(adapter, context.getRecipientUpdate());
        }
        catch (ConverterException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex);
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.RCPT_UPDATE_ERROR);
            throw new ProcessHandlerException(I18NCode.RCPT_UPDATE_ERROR, ex);
        }
    }
}

