/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.core.scheduling;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.sds.core.DatatierRecovery;
import com.cognos.sds.core.persist.ObjectPersist;
import com.cognos.sds.core.persist.ObjectPersistException;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import noticecast.logictier.NCObjectType;
import noticecast.persist.INCObjectUpdate;
import noticecast.scheduling.nc.ITaskSchedule;
import noticecast.scheduling.nc.ScheduleLink;

public class NCScheduleRetrieveHandler
implements ProcessHandler {
    private static NCScheduleRetrieveHandler instance = new NCScheduleRetrieveHandler();

    private NCScheduleRetrieveHandler() {
    }

    public static NCScheduleRetrieveHandler getInstance() {
        return instance;
    }

    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        ITaskSchedule taskSchedule = (ITaskSchedule)context.getTaskScheduleUpdate().getObject();
        ScheduleLink[] links = taskSchedule.getScheduleLinks();
        if (links == null || links.length != 1) {
            DatatierRecovery.instance().repairTaskScheduleAndTask(taskSchedule.getNCObjectId());
            throw new ProcessHandlerException(I18NCode.SCHD_RETRIEVE_ERROR);
        }
        NCObjectId scheduleId = links[0].getScheduleId();
        INCObjectUpdate objUp = null;
        Object ncScheduleWrapper = null;
        try {
            objUp = ObjectPersist.getInstance().getNCObjectUpdate(NCObjectType.SCHEDULE, scheduleId);
        }
        catch (ObjectPersistException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)((Object)ex));
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SCHDR_OBJECT_NOT_FOUND, (Object[])new String[]{scheduleId.toString()});
            DatatierRecovery.instance().repairTaskScheduleAndTask(taskSchedule.getNCObjectId());
            throw new ProcessHandlerException(I18NCode.SCHDR_OBJECT_NOT_FOUND, new Object[]{scheduleId.toString()}, (LocalizableException)((Object)ex));
        }
        context.setNcScheduleUpdate(objUp);
    }
}

