/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.core.scheduling;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.sds.adapter.ScheduleAdapter;
import com.cognos.sds.api.converter.ConverterException;
import com.cognos.sds.api.converter.scheduling.ScheduleConverter;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import noticecast.scheduling.nc.NcScheduleWrapper;
import noticecast.scheduling.schedules.ScheduleType;

public class ScheduleBuildHandler
implements ProcessHandler {
    private static ScheduleBuildHandler instance = new ScheduleBuildHandler();

    private ScheduleBuildHandler() {
    }

    public static ScheduleBuildHandler getInstance() {
        return instance;
    }

    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        ScheduleAdapter adapterObject = context.getScheduleAdapter();
        NcScheduleWrapper schedule = null;
        try {
            ScheduleConverter converter = new ScheduleConverter();
            schedule = (NcScheduleWrapper)converter.createNCObject(adapterObject);
        }
        catch (ConverterException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex);
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SCHD_CREATE_ERROR);
            throw new ProcessHandlerException(I18NCode.SCHD_CREATE_ERROR, ex);
        }
        if (schedule != null) {
            context.setNcSchedule(schedule);
            if (!schedule.getSchedule().getType().equals(ScheduleType.TRIGGERED_SCHEULE) && !schedule.getSchedule().getType().equals(ScheduleType.SUBSCRIPTION_SCHEDULE)) {
                context.addRuntimeUpdate(schedule);
            }
        }
    }
}

