/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.core.scheduling;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.util.HashList;
import com.cognos.sds.adapter.ScheduleSynchInputAdapter;
import com.cognos.sds.adapter.ScheduleSynchOutputAdapter;
import com.cognos.sds.core.DatatierRecovery;
import com.cognos.sds.core.persist.PublishedGuidException;
import com.cognos.sds.core.persist.PublishedGuidPersist;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import noticecast.accesscontrol.CMVersion;
import noticecast.logictier.base.INCFeatherWeight;

public class ScheduleVersionHandler
implements ProcessHandler {
    private static ScheduleVersionHandler instance = new ScheduleVersionHandler();

    private ScheduleVersionHandler() {
    }

    public static ScheduleVersionHandler getInstance() {
        return instance;
    }

    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        HashMap featherweight_map = null;
        HashMap synchinfo_map = null;
        try {
            featherweight_map = this.mapNCFeatherweightTasks(context.getFeatherWeights());
            ScheduleSynchInputAdapter[] synchAdapters = context.getScheduleSynchInputAdapters();
            synchinfo_map = this.mapCMScheduleList((Connection)context.getConnection(), synchAdapters, featherweight_map);
            HashList action_list = new HashList();
            this.getSchedulesForDelete(context.getFeatherWeights(), synchinfo_map, action_list, context);
            this.getSchedulesForAddOrUpdate(synchAdapters, featherweight_map, action_list);
            this.processActionList(action_list, context);
        }
        catch (Exception ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).debug("Error in synchronize schedules.");
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.SCHD_RETRIEVE_ERROR);
            throw new ProcessHandlerException(I18NCode.SCHD_RETRIEVE_ERROR);
        }
    }

    private void createDeleteOutput(List deletes, ProcessContext context, List outputs) throws ProcessHandlerException {
        Iterator deletesIter = deletes.iterator();
        ArrayList<String> delete_guids = new ArrayList<String>();
        int i = 0;
        while (deletesIter.hasNext()) {
            INCFeatherWeight fw = (INCFeatherWeight)deletesIter.next();
            String delete_guid = null;
            try {
                delete_guid = PublishedGuidPersist.getInstance().getGuid((Connection)context.getConnection(), fw.getNCObjectId());
                delete_guids.add(delete_guid);
                outputs.add(ScheduleSynchOutputAdapter.createAdapter(delete_guid, "delete"));
            }
            catch (PublishedGuidException pex) {
                DatatierRecovery.instance().repairTaskAndTaskSchedule(fw.getNCObjectId());
            }
            ++i;
        }
        String[] deleted = new String[delete_guids.size()];
        delete_guids.toArray(deleted);
        context.setTaskIds(deleted);
    }

    private void createAddUpdateOutput(List updateAdd, List outputs, String action) {
        for (ScheduleSynchInputAdapter input : updateAdd) {
            outputs.add(ScheduleSynchOutputAdapter.createAdapter(input, action));
        }
    }

    private void processActionList(HashList action_list, ProcessContext context) throws ProcessHandlerException {
        Iterator keys = action_list.keySet().iterator();
        ArrayList full_list = new ArrayList();
        this.createDeleteOutput(action_list.get((Object)"delete"), context, full_list);
        this.createAddUpdateOutput(action_list.get((Object)"update"), full_list, "update");
        this.createAddUpdateOutput(action_list.get((Object)"add"), full_list, "add");
        ScheduleSynchOutputAdapter[] outputs = new ScheduleSynchOutputAdapter[full_list.size()];
        full_list.toArray(outputs);
        context.setScheduleSynchOutputAdapter(outputs);
    }

    private void getSchedulesForDelete(INCFeatherWeight[] nc_feathers, HashMap synchinfo_map, HashList action_list, ProcessContext context) throws ProcessHandlerException {
        for (int i = 0; i < nc_feathers.length; ++i) {
            NCObjectId id = nc_feathers[i].getNCObjectId();
            if (synchinfo_map.containsKey(id)) continue;
            action_list.put((Object)"delete", (Object)nc_feathers[i]);
        }
    }

    private void getSchedulesForAddOrUpdate(ScheduleSynchInputAdapter[] synchAdapters, HashMap featherweight_map, HashList action_list) {
        for (int i = 0; i < synchAdapters.length; ++i) {
            NCObjectId task_id = synchAdapters[i].getNCTaskId();
            if (task_id == null || !featherweight_map.containsKey(task_id)) {
                action_list.put((Object)"add", (Object)synchAdapters[i]);
                continue;
            }
            INCFeatherWeight fw = (INCFeatherWeight)featherweight_map.get(synchAdapters[i].getNCTaskId());
            CMVersion ourVersion = null;
            ourVersion = fw != null ? fw.getCMVersion() : new CMVersion();
            if (ourVersion.equals(synchAdapters[i].getVersion())) continue;
            action_list.put((Object)"update", (Object)synchAdapters[i]);
        }
    }

    private HashMap mapNCFeatherweightTasks(INCFeatherWeight[] feathers) {
        HashMap<NCObjectId, INCFeatherWeight> featherweight_map = new HashMap<NCObjectId, INCFeatherWeight>();
        for (int i = 0; i < feathers.length; ++i) {
            featherweight_map.put(feathers[i].getNCObjectId(), feathers[i]);
        }
        return featherweight_map;
    }

    private HashMap mapCMScheduleList(Connection connection, ScheduleSynchInputAdapter[] synchAdapters, HashMap featherweightmap) throws ProcessHandlerException {
        HashMap<NCObjectId, ScheduleSynchInputAdapter> synchinfoMap = new HashMap<NCObjectId, ScheduleSynchInputAdapter>();
        if (synchAdapters == null || synchAdapters.length == 0) {
            return synchinfoMap;
        }
        String[] guids = new String[synchAdapters.length];
        for (int i = 0; i < synchAdapters.length; ++i) {
            guids[i] = synchAdapters[i].getTaskId();
        }
        NCObjectId[] ncIds = null;
        try {
            ncIds = PublishedGuidPersist.getInstance().getNCObjectIds(connection, guids);
        }
        catch (PublishedGuidException e) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.GEN_RETRIEVE_ERROR);
            throw new ProcessHandlerException(I18NCode.GEN_RETRIEVE_ERROR, (LocalizableException)((Object)e));
        }
        for (int i = 0; i < synchAdapters.length; ++i) {
            if (ncIds[i] == null || !featherweightmap.containsKey(ncIds[i])) continue;
            synchAdapters[i].setNCTaskId(ncIds[i]);
            synchinfoMap.put(ncIds[i], synchAdapters[i]);
        }
        return synchinfoMap;
    }
}

