/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.core.scheduling;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.Schedule;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.ems.EventManagementCategory;
import com.cognos.i18n.Calendar;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.jdbc.util.SqlResourceCloser;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.objectid.NCObjectIdUtil;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import noticecast.logictier.NCObjectType;

public class TriggeredScheduleTaskRetrieveHandler
implements ProcessHandler {
    private static final String TAB_R_NEWSITEMS_NCOBJECTS = "R_NEWSITEMS_NCOBJECTS ";
    private static final String COL_FK_NCID = "FK_NCID";
    private static final String COL_NID = "NID";
    private static final String SQL_TRIGGER_1 = "SELECT FK_NCID FROM NC_SCHEDULE,R_TASKSCHEDULE_SCHEDULE, R_NEWSITEMS_NCOBJECTS, NC_TASKSCHEDULE WHERE (FK_TASK_ID = FK_NCID) AND (FK_TASKSCHEDULE_ID = PK_TASKSCHEDULE_ID) AND (PK_SCHEDULE_ID = FK_SCHEDULE_ID) AND (START_DATE < ";
    private static final String SQL_TRIGGER_2 = ") AND (END_DATE IS NULL OR END_DATE > ";
    private static final String SQL_TRIGGER_3 = ") AND NID IN (";
    private static final String SQL_TRIGGER_4 = ")";

    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        try {
            String trigger = context.getTriggerId();
            Set folders = context.getTriggerFolders();
            BiBusHeader header = context.getBiBusHeader();
            String[] schedules = this.retrieveScheduleIds(header, trigger, folders);
            NCObjectId[] ids = this.retrieveTaskIds((Connection)context.getConnection(), schedules);
            context.setTriggeredTasks(ids);
        }
        catch (SQLException e) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_UNABLE_RETRIEVE_OBJECT, (Object[])new String[]{" schedule "});
            throw new ProcessHandlerException(I18NCode.PERST_UNABLE_RETRIEVE_OBJECT, new Object[]{NCObjectType.SCHEDULE});
        }
    }

    private String[] retrieveScheduleIds(BiBusHeader header, String trigger, Set folders) throws ProcessHandlerException {
        HashSet ids = new HashSet();
        if (folders.isEmpty()) {
            StringBuffer path = new StringBuffer(100);
            path.append("//schedule[@triggerName='");
            path.append(trigger);
            path.append("'][@active='true']");
            ids.addAll(this.getTriggerScheduleIDsForPath(header, path.toString()));
        } else {
            for (String folderSearchPath : folders) {
                StringBuffer path = new StringBuffer(200);
                if (!folderSearchPath.startsWith("/")) {
                    path.append("/");
                }
                path.append(folderSearchPath);
                if (folderSearchPath.endsWith("/")) {
                    path.append("/schedule[@triggerName='");
                } else {
                    path.append("//schedule[@triggerName='");
                }
                path.append(trigger);
                path.append("'][@active='true']");
                ids.addAll(this.getTriggerScheduleIDsForPath(header, path.toString()));
            }
        }
        return ids.toArray(new String[ids.size()]);
    }

    private Set getTriggerScheduleIDsForPath(BiBusHeader header, String path) throws ProcessHandlerException {
        ContentManagerServiceClientPort cm = null;
        BaseClass[] classes = null;
        HashSet<String> ids = new HashSet<String>();
        try {
            cm = Client.instance().getContentManagerServiceClient(new JobBiBusHeaders(header));
            classes = cm.query(new SearchPathMultipleObject(path), new PropEnum[]{PropEnum.taskID}, new Sort[0], new QueryOptions());
        }
        catch (EMFSecurityException e) {
            String msg = "TriggeredScheduleTaskRetrieveHandler.retrieveScheduleIds(...): Service Exception retrieving cached binding port.";
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).debug(msg);
            throw new ProcessHandlerException(I18NCode.IO_CM_COMMS_ERROR);
        }
        catch (SDKClientException e) {
            String msg = "TriggeredScheduleTaskRetrieveHandler.retrieveScheduleIds(...): SDKClient Exception retrieving current session information for the user.";
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).debug(msg);
            throw new ProcessHandlerException(I18NCode.IO_CM_COMMS_ERROR, (LocalizableException)((Object)e));
        }
        finally {
            if (cm != null) {
                cm.close();
            }
        }
        if (classes != null && classes.length > 0) {
            for (int i = 0; i < classes.length; ++i) {
                String id;
                if (!(classes[i] instanceof Schedule)) continue;
                Schedule schedule = (Schedule)classes[i];
                String string = id = schedule.getTaskID() != null ? schedule.getTaskID().getValue() : null;
                if (id == null) continue;
                ids.add(id);
            }
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NCObjectId[] retrieveTaskIds(Connection conn, String[] schedules) throws SQLException {
        ArrayList<NCObjectId> ids = new ArrayList<NCObjectId>();
        ArrayBatch scheduleBatches = new ArrayBatch(schedules, 1000);
        if (scheduleBatches.hasMore()) {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = conn.createStatement();
                while (scheduleBatches.hasMore()) {
                    rs = stmt.executeQuery(this.getSQL(scheduleBatches.getBatch()));
                    while (rs.next()) {
                        ids.add(NCObjectIdUtil.instance().createObjectId(rs, COL_FK_NCID));
                    }
                    rs.close();
                    rs = null;
                }
            }
            finally {
                SqlResourceCloser.closeResources(rs, (Statement)stmt);
            }
        }
        return ids.toArray(new NCObjectId[ids.size()]);
    }

    private String getSQL(String[] ids) {
        StringBuffer buffer = new StringBuffer(SQL_TRIGGER_1);
        Date c = Calendar.getInstance().getTime();
        long currentTimeInMillis = c.getTime();
        buffer.append(currentTimeInMillis);
        buffer.append(SQL_TRIGGER_2);
        buffer.append(currentTimeInMillis);
        buffer.append(SQL_TRIGGER_3);
        for (int i = 0; i < ids.length; ++i) {
            buffer.append("'" + ids[i] + "'");
            if (i == ids.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append(SQL_TRIGGER_4);
        return buffer.toString();
    }

    private static class ArrayBatch {
        private String[] m_source;
        private int m_batch_size;
        private int m_cursor = 0;

        public ArrayBatch(String[] ids, int batch_size) {
            this.m_source = ids;
            this.m_batch_size = batch_size > 0 ? batch_size : 1000;
        }

        public boolean hasMore() {
            return this.m_source != null && this.m_cursor < this.m_source.length;
        }

        public String[] getBatch() {
            if (this.m_source.length - this.m_cursor <= 0) {
                return new String[0];
            }
            int batch_size = 0;
            batch_size = this.m_source.length - this.m_cursor > this.m_batch_size ? this.m_batch_size : this.m_source.length - this.m_cursor;
            String[] batch = new String[batch_size];
            System.arraycopy(this.m_source, this.m_cursor, batch, 0, batch_size);
            this.m_cursor += batch_size;
            return batch;
        }
    }
}

