/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.core.scheduling;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.jdbc.util.SqlResourceCloser;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.objectid.NCObjectIdUtil;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;

public class TriggeredSubscriptionScheduleTaskRetrieveHandler
implements ProcessHandler {
    private String M_SELECT = "SELECT NC_TASK.PK_TASK_ID FROM NC_SCHEDULE, NC_TASK, NC_TASKSCHEDULE, R_TASKSCHEDULE_SCHEDULE WHERE NC_TASKSCHEDULE.FK_TASK_ID = NC_TASK.PK_TASK_ID AND NC_TASKSCHEDULE.PK_TASKSCHEDULE_ID = R_TASKSCHEDULE_SCHEDULE.FK_TASKSCHEDULE_ID AND R_TASKSCHEDULE_SCHEDULE.FK_SCHEDULE_ID = NC_SCHEDULE.PK_SCHEDULE_ID AND R_TASKSCHEDULE_SCHEDULE.IS_ACTIVE = 1 AND NC_SCHEDULE.PERIODICAL_PRODUCER_ID = ? AND NC_SCHEDULE.START_DATE < ? AND (NC_SCHEDULE.END_DATE IS NULL OR NC_SCHEDULE.END_DATE > ?)";

    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        String producerID = context.getProducerID();
        String producerStoreID = this.getProducerStoreID(producerID, context);
        NCObjectId[] ids = this.retrieveTaskIds((Connection)context.getConnection(), producerStoreID);
        context.setTriggeredTasks(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NCObjectId[] retrieveTaskIds(Connection conn, String producerStoreID) {
        ArrayList<NCObjectId> ids = new ArrayList<NCObjectId>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(this.M_SELECT);
            ps.setString(1, producerStoreID);
            Date c = new Date();
            long currentTimeInMillis = c.getTime();
            ps.setLong(2, currentTimeInMillis);
            ps.setLong(3, currentTimeInMillis);
            rs = ps.executeQuery();
            while (rs.next()) {
                ids.add(NCObjectIdUtil.instance().createObjectId(rs, 1));
            }
            SqlResourceCloser.closeResources((ResultSet)rs, (Statement)ps);
        }
        catch (SQLException e) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug((Throwable)e);
        }
        finally {
            SqlResourceCloser.closeResources(rs, (Statement)ps);
        }
        return ids.toArray(new NCObjectId[ids.size()]);
    }

    private String getProducerStoreID(String producerID, ProcessContext context) throws ProcessHandlerException {
        String producerStoreID = null;
        if (producerID.startsWith("storeID(")) {
            producerStoreID = producerID.substring(9, 42);
        } else {
            ContentManagerServiceClientPort cm = null;
            BaseClass[] classes = null;
            try {
                cm = Client.instance().getContentManagerServiceClient(new JobBiBusHeaders(context.getBiBusHeader()));
                classes = cm.query(new SearchPathMultipleObject(producerID), new PropEnum[]{PropEnum.storeID}, new Sort[0], new QueryOptions());
            }
            catch (EMFSecurityException e) {
                String msg = "TriggeredSubscriptionScheduleTaskRetrieveHandler.retrieveScheduleIds(...): Service Exception retrieving cached binding port.";
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).debug(msg);
                throw new ProcessHandlerException(I18NCode.IO_CM_COMMS_ERROR);
            }
            catch (SDKClientException e) {
                String msg = "TriggeredSubscriptionScheduleTaskRetrieveHandler.retrieveScheduleIds(...): SDKClient Exception retrieving current session information for the user.";
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).debug(msg);
                throw new ProcessHandlerException(I18NCode.IO_CM_COMMS_ERROR, (LocalizableException)((Object)e));
            }
            finally {
                if (cm != null) {
                    cm.close();
                }
            }
            if (classes != null && classes.length == 1) {
                producerStoreID = classes[0].getStoreID().getValue().get_value();
            }
        }
        return producerStoreID;
    }
}

