/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.core.task;

import com.cognos.developer.schemas.bibus._3.OptionArrayProp;
import com.cognos.developer.schemas.bibus._3.ParameterValueArrayProp;
import com.cognos.developer.schemas.bibus._3.Schedule;
import com.cognos.sds.adapter.ScheduleAdapter;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.namespace.QName;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.SerializationContext;

public class ScheduleCommandHandler
implements ProcessHandler {
    public static final ScheduleCommandHandler instance = new ScheduleCommandHandler();

    private ScheduleCommandHandler() {
    }

    public static ScheduleCommandHandler getInstance() {
        return instance;
    }

    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        ScheduleAdapter adapter = context.getScheduleAdapter();
        boolean isTransient = adapter.getType().equals("transient");
        String command = this.getCommand(adapter.getSchedule(), isTransient, null);
        adapter.setCommand(command);
    }

    private String getCommand(Schedule theSchedule, boolean isTransient, String jobID) {
        StringBuffer buffer = new StringBuffer(1000);
        buffer.append("<SOAP-ENV:Body xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\"");
        buffer.append(" xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\">");
        buffer.append("<ems:runAt xmlns:ems=\"http://developer.cognos.com/schemas/eventManagementService/1\">");
        buffer.append("<objectPath xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"bus:searchPathSingleObject\">");
        if (isTransient) {
            buffer.append("<xsl:value-of select=\"search\"/></objectPath>");
        } else {
            buffer.append("//schedule[@taskID='");
            if (jobID == null) {
                buffer.append("abcdefghijklmtaskidnopqrstuvwxyz");
            } else {
                buffer.append(jobID);
            }
            buffer.append("']/parent::*</objectPath>");
        }
        MessageContext msgContext = MessageContext.getCurrentContext();
        OptionArrayProp options = theSchedule.getOptions();
        if (options == null || options.getValue() == null) {
            buffer.append("<options xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"SOAP-ENC:Array\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" SOAP-ENC:arrayType=\"bus:option[0]\"/>");
        } else {
            try {
                QName optionsQN = new QName("options");
                StringWriter stringWriter = new StringWriter();
                SerializationContext serContext = new SerializationContext((Writer)stringWriter, msgContext);
                serContext.setSendDecl(false);
                serContext.setDoMultiRefs(false);
                serContext.serialize(optionsQN, null, (Object)options.getValue(), null, false, Boolean.TRUE);
                String msgString = ((Object)stringWriter).toString();
                buffer.append(msgString);
            }
            catch (Exception ioe) {
                buffer.append("<options xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"SOAP-ENC:Array\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" SOAP-ENC:arrayType=\"bus:option[0]\"/>");
            }
        }
        ParameterValueArrayProp parameters = theSchedule.getParameters();
        if (parameters == null || parameters.getValue() == null) {
            buffer.append("<parameterValues xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"SOAP-ENC:Array\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" SOAP-ENC:arrayType=\"bus:parameterValue[0]\"/>");
        } else {
            try {
                QName element = new QName("parameterValues");
                StringWriter stringWriter = new StringWriter();
                SerializationContext serContext = new SerializationContext((Writer)stringWriter, msgContext);
                serContext.setSendDecl(false);
                serContext.setDoMultiRefs(false);
                serContext.serialize(element, null, (Object)parameters.getValue(), null, false, Boolean.TRUE);
                String msgString = ((Object)stringWriter).toString();
                buffer.append(msgString);
            }
            catch (Exception ioe) {
                buffer.append("<parameterValues xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"SOAP-ENC:Array\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" SOAP-ENC:arrayType=\"bus:parameterValue[0]\"/>");
            }
        }
        buffer.append("</ems:runAt></SOAP-ENV:Body>");
        return buffer.toString();
    }
}

