/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.core.task;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.sds.api.converter.ConverterException;
import com.cognos.sds.api.converter.task.JobServiceTaskConverter;
import com.cognos.sds.api.converter.task.NotificationTaskConverter;
import com.cognos.sds.api.converter.task.TaskConverter;
import com.cognos.sds.core.task.TaskScheduleBuildHandler;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.agent.ITask;

public class TaskBuildHandler
implements ProcessHandler {
    public static final TaskBuildHandler instance = new TaskBuildHandler();

    private TaskBuildHandler() {
    }

    public static TaskBuildHandler getInstance() {
        return instance;
    }

    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        ITask task = null;
        try {
            TaskConverter converter = context.getTaskType().equals(NCObjectType.NOTIFICATION_AGENT) ? new NotificationTaskConverter(context.getRecipient()) : new JobServiceTaskConverter(context.getRecipient());
            task = (ITask)converter.createNCObject(context.getScheduleAdapter());
        }
        catch (ConverterException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex);
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.AGENT_CREATE_ERROR_GUID, (Object[])new String[]{task.getNCObjectId().toString()});
            throw new ProcessHandlerException(I18NCode.AGENT_CREATE_ERROR_GUID, new Object[]{context.getScheduleAdapter().getTaskID()}, ex);
        }
        context.setTask(task);
        TaskScheduleBuildHandler.getInstance().invoke(context);
    }
}

