/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.core.task;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.sds.adapter.ScheduleAdapter;
import com.cognos.sds.core.DatatierRecovery;
import com.cognos.sds.core.ScheduleMender;
import com.cognos.sds.core.persist.ObjectPersist;
import com.cognos.sds.core.persist.ObjectPersistException;
import com.cognos.sds.core.persist.PublishedGuidException;
import com.cognos.sds.core.persist.PublishedGuidPersist;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import java.sql.Connection;
import noticecast.logictier.NCObjectType;
import noticecast.persist.INCObjectUpdate;

public class TaskRetrieveHandler
implements ProcessHandler {
    public static final TaskRetrieveHandler instance = new TaskRetrieveHandler();

    private TaskRetrieveHandler() {
    }

    public static TaskRetrieveHandler getInstance() {
        return instance;
    }

    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        ScheduleAdapter adapter = context.getScheduleAdapter();
        JDBCConnection connection = context.getConnection();
        String guid = adapter.getTaskID();
        INCObjectUpdate objUp = null;
        Object task = null;
        NCObjectId ncId = null;
        try {
            ncId = PublishedGuidPersist.getInstance().getNCObjectId((Connection)connection, guid);
            objUp = ObjectPersist.getInstance().getNCObjectUpdate(NCObjectType.TASK, ncId);
        }
        catch (PublishedGuidException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)((Object)ex));
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SCHDR_OBJECT_NOT_FOUND, (Object[])new String[]{guid});
            ScheduleMender.instance().mendSchedule(guid);
            ProcessHandlerException phe = new ProcessHandlerException(I18NCode.SCHDR_OBJECT_NOT_FOUND, new Object[]{guid}, (LocalizableException)((Object)ex));
            throw new ProcessHandlerException(I18NCode.SCHD_RETRIEVE_ERROR, (LocalizableException)((Object)phe));
        }
        catch (ObjectPersistException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)((Object)ex));
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.INFO, I18NCode.SCHD_RETRIEVE_ERROR);
            if (objUp == null && ncId != null) {
                DatatierRecovery.instance().repairTaskAndTaskSchedule(ncId);
            }
            ProcessHandlerException phe = new ProcessHandlerException(I18NCode.SCHDR_OBJECT_NOT_FOUND, new Object[]{guid}, (LocalizableException)((Object)ex));
            throw new ProcessHandlerException(I18NCode.SCHD_RETRIEVE_ERROR, (LocalizableException)((Object)phe));
        }
        if (objUp == null || ncId == null) {
            ProcessHandlerException phe = new ProcessHandlerException(I18NCode.SCHDR_OBJECT_NOT_FOUND, new Object[]{guid});
            throw new ProcessHandlerException(I18NCode.SCHD_RETRIEVE_ERROR, (LocalizableException)((Object)phe));
        }
        context.setTaskUpdate(objUp);
        context.setTaskId(ncId);
    }
}

