/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.core.task;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.sds.adapter.ScheduleAdapter;
import com.cognos.sds.api.converter.ConverterException;
import com.cognos.sds.api.converter.task.TaskScheduleConverter;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import noticecast.scheduling.nc.ITaskSchedule;
import noticecast.scheduling.nc.NcScheduleWrapper;

public class TaskScheduleBuildHandler
implements ProcessHandler {
    private static final TaskScheduleBuildHandler instance = new TaskScheduleBuildHandler();

    private TaskScheduleBuildHandler() {
    }

    public static TaskScheduleBuildHandler getInstance() {
        return instance;
    }

    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        ScheduleAdapter adapter = context.getScheduleAdapter();
        NcScheduleWrapper ncSchedule = context.getNcSchedule();
        NCObjectId taskID = context.getTask().getNCObjectId();
        NcScheduleWrapper[] ncSchedules = new NcScheduleWrapper[]{ncSchedule};
        ITaskSchedule ts = null;
        try {
            TaskScheduleConverter converter = new TaskScheduleConverter(taskID, ncSchedules);
            ts = (ITaskSchedule)converter.createNCObject(adapter);
        }
        catch (ConverterException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex);
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SCHDR_CREATE_ERROR);
            throw new ProcessHandlerException(I18NCode.SCHDR_CREATE_ERROR, ex);
        }
        context.setTaskSchedule(ts);
    }
}

