/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.core.task;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.sds.core.DatatierRecovery;
import com.cognos.sds.core.persist.ObjectPersist;
import com.cognos.sds.core.persist.ObjectPersistException;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import noticecast.datatier.helperoptions.HelperOptionImpl;
import noticecast.datatier.helperoptions.HelperOptionWithParam;
import noticecast.logictier.NCObjectType;
import noticecast.persist.INCObjectUpdate;

public class TaskScheduleRetrieveHandler
implements ProcessHandler {
    public static final TaskScheduleRetrieveHandler instance = new TaskScheduleRetrieveHandler();

    private TaskScheduleRetrieveHandler() {
    }

    public static TaskScheduleRetrieveHandler getInstance() {
        return instance;
    }

    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        NCObjectId taskId = context.getTaskId();
        HelperOptionWithParam helperOption = new HelperOptionWithParam(HelperOptionImpl.TASKSCHEDULE_FROM_TASK_ID, new String[]{taskId.toString()});
        INCObjectUpdate[] objUps = null;
        try {
            objUps = ObjectPersist.getInstance().getNCObjectUpdates(NCObjectType.TASK_SCHEDULE, helperOption);
        }
        catch (ObjectPersistException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)((Object)ex));
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SCHDR_DESCRIBE_ERROR);
            DatatierRecovery.instance().repairTaskAndTaskSchedule(taskId);
            throw new ProcessHandlerException(I18NCode.SCHDR_DESCRIBE_ERROR, (LocalizableException)((Object)ex));
        }
        if (objUps == null) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SCHDR_OBJECT_NOT_FOUND, (Object[])new String[]{taskId.toString()});
            DatatierRecovery.instance().repairTaskAndTaskSchedule(taskId);
            ProcessHandlerException phe = new ProcessHandlerException(I18NCode.SCHDR_OBJECT_NOT_FOUND, new Object[]{taskId.toString()});
            throw new ProcessHandlerException(I18NCode.SCHDR_DESCRIBE_ERROR, (LocalizableException)((Object)phe));
        }
        if (objUps.length != 1) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SCHDR_OBJECT_NOT_FOUND, (Object[])new String[]{taskId.toString()});
            DatatierRecovery.instance().repairTaskAndTaskSchedule(taskId);
            ProcessHandlerException phe = new ProcessHandlerException(I18NCode.SCHDR_OBJECT_NOT_FOUND, new Object[]{taskId.toString()});
            throw new ProcessHandlerException(I18NCode.SCHDR_DESCRIBE_ERROR, (LocalizableException)((Object)phe));
        }
        context.setTaskScheduleUpdate(objUps[0]);
    }
}

