/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.core.task;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.sds.adapter.ScheduleAdapter;
import com.cognos.sds.api.converter.ConverterException;
import com.cognos.sds.api.converter.task.TaskScheduleConverter;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import noticecast.persist.INCObjectUpdate;
import noticecast.scheduling.nc.ITaskSchedule;
import noticecast.scheduling.nc.NcScheduleWrapper;

public class TaskScheduleUpdateHandler
implements ProcessHandler {
    private static final TaskScheduleUpdateHandler instance = new TaskScheduleUpdateHandler();

    private TaskScheduleUpdateHandler() {
    }

    public static TaskScheduleUpdateHandler getInstance() {
        return instance;
    }

    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        ScheduleAdapter adapter = context.getScheduleAdapter();
        INCObjectUpdate updateObject = context.getTaskScheduleUpdate();
        NCObjectId taskId = context.getTaskId();
        INCObjectUpdate ncSchduleUpdate = context.getNcScheduleUpdate();
        NcScheduleWrapper ncSchduleWrapper = (NcScheduleWrapper)ncSchduleUpdate.getObject();
        NcScheduleWrapper[] ncSchedules = new NcScheduleWrapper[]{ncSchduleWrapper};
        try {
            TaskScheduleConverter converter = new TaskScheduleConverter(taskId, ncSchedules);
            converter.updateNCObject(adapter, updateObject);
        }
        catch (ConverterException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex);
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.SCHDR_UPDATE_ERROR);
            throw new ProcessHandlerException(I18NCode.SCHDR_UPDATE_ERROR, ex);
        }
        context.setTaskSchedule((ITaskSchedule)context.getTaskScheduleUpdate().getObject());
    }
}

