/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.core.task;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.sds.adapter.ScheduleAdapter;
import com.cognos.sds.api.converter.ConverterException;
import com.cognos.sds.api.converter.task.JobServiceTaskConverter;
import com.cognos.sds.api.converter.task.NotificationTaskConverter;
import com.cognos.sds.api.converter.task.TaskConverter;
import com.cognos.sds.core.task.TaskScheduleUpdateHandler;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.recipient.IRecipient;

public class TaskUpdateHandler
implements ProcessHandler {
    public static final TaskUpdateHandler instance = new TaskUpdateHandler();

    private TaskUpdateHandler() {
    }

    public static TaskUpdateHandler getInstance() {
        return instance;
    }

    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        ScheduleAdapter adapter = context.getScheduleAdapter();
        String guid = context.getScheduleAdapter().getTaskID();
        try {
            TaskConverter converter = context.getTaskType().equals(NCObjectType.NOTIFICATION_AGENT) ? new NotificationTaskConverter((IRecipient)context.getRecipientUpdate().getObject()) : new JobServiceTaskConverter((IRecipient)context.getRecipientUpdate().getObject());
            converter.updateNCObject(adapter, context.getTaskUpdate());
        }
        catch (ConverterException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex);
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.AGENT_UPDATE_ERROR_GUID, (Object[])new String[]{guid});
            throw new ProcessHandlerException(I18NCode.AGENT_UPDATE_ERROR_GUID, new Object[]{guid}, ex);
        }
        TaskScheduleUpdateHandler.getInstance().invoke(context);
    }
}

