/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.core.taskschedule;

import com.cognos.i18n.Calendar;
import com.cognos.i18n.TimeZone;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.UserAccountUtil;
import com.cognos.monitor.api.MonitorServiceException;
import com.cognos.sds.adapter.Duration;
import com.cognos.sds.core.persist.PersistHandler;
import com.cognos.sds.core.persist.TransactionHandler;
import com.cognos.sds.core.persist.UpdatePersistAction;
import com.cognos.sds.core.task.TaskScheduleRetrieveHandler;
import com.cognos.sds.core.taskschedule.TaskSchedulePersistInfo;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.EventTransition;
import com.cognos.sds.event.EventsContext;
import com.cognos.sds.handler.IChainHandler;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import java.util.Date;
import noticecast.runtime.IRunTimeManager;
import noticecast.runtime.RunTimeManager;
import noticecast.scheduling.nc.ITaskSchedule;
import noticecast.scheduling.nc.ScheduleLink;

public class TaskScheduleEventsHandler
implements ProcessHandler {
    private ProcessHandler m_tasScheduleRetrieveHandler = TaskScheduleRetrieveHandler.getInstance();
    private IChainHandler m_persistHandler = new TransactionHandler();

    public TaskScheduleEventsHandler() {
        this.m_persistHandler.add(new PersistHandler(new UpdatePersistAction(), new TaskSchedulePersistInfo()));
    }

    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        EventsContext eventsContext = context.getEventsContext();
        this.m_tasScheduleRetrieveHandler.invoke(context);
        ITaskSchedule ts = (ITaskSchedule)context.getTaskScheduleUpdate().getObject();
        TimeZone taskScheduleTz = null;
        Date nextExecution = ts.getNextExecution();
        boolean updateRunTime = false;
        Event[] events = eventsContext.getEvents();
        Date eventDate = null;
        UserAccountUtil userAccountUtil = new UserAccountUtil(new JobBiBusHeaders(context.getBiBusHeader()));
        String user = userAccountUtil.getUserName();
        for (int i = 0; i < events.length; ++i) {
            if (events[i].duration != null) {
                if (taskScheduleTz == null) {
                    taskScheduleTz = this.getTimeZoneForTaskSchedule(ts);
                }
                this.updateDuration(events[i], taskScheduleTz);
            }
            eventDate = events[i].getScheduledStartDate();
            EventStatus newStatus = events[i].getStatus();
            if (newStatus != null) {
                EventStatus existingStatus = EventStatus.SCHEDULED;
                Event existingEvent = ts.getOverrideEvent(eventDate);
                if (existingEvent != null && existingEvent.getStatus() != null) {
                    existingStatus = existingEvent.getStatus();
                }
                if (!existingStatus.equals((Object)newStatus)) {
                    try {
                        EventTransition.validate(existingStatus, newStatus);
                    }
                    catch (MonitorServiceException e) {
                        SDSLogger logger = SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME);
                        logger.log(SDSLevel.WARN, (LocalizableException)((Object)e));
                        logger.debug("UpdateFutureEventsHandler.invoke(): Invalid Event Transition detected.");
                        eventsContext.addUpdateEventFault(e);
                        return;
                    }
                }
            }
            ts.updateOverrideEvent(events[i], user);
            if (!eventDate.before(nextExecution) && !eventDate.equals(nextExecution)) continue;
            updateRunTime = true;
        }
        this.m_persistHandler.invoke(context);
        if (updateRunTime) {
            IRunTimeManager rtm = RunTimeManager.getInstance();
            rtm.updateLiveEnvironment(ts, 0);
        }
        eventsContext.addToProcessedEventsCount(events.length);
    }

    private TimeZone getTimeZoneForTaskSchedule(ITaskSchedule ts) {
        TimeZone tz = null;
        ScheduleLink[] links = ts.getScheduleLinks();
        if (links != null && links.length > 0) {
            tz = links[0].getSchedule().getSchedule().getTimeZone();
        }
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        return tz;
    }

    private void updateDuration(Event event, TimeZone tz) {
        Duration duration = new Duration(event.duration);
        Calendar cal = Calendar.getInstance((TimeZone)tz);
        cal.setTime(event.getScheduledStartDate());
        cal.add(1, duration.getYears());
        cal.add(2, duration.getMonths());
        cal.add(3, duration.getWeeks());
        cal.add(5, duration.getDays());
        cal.add(11, duration.getHours());
        cal.add(12, duration.getMinutes());
        cal.add(13, duration.getSeconds());
        event.setRequestedStartDate(cal.getTime());
        event.duration = null;
    }
}

