/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.event;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.sds.event.IEventId;
import java.util.Comparator;
import java.util.Date;
import noticecast.scheduling.core.ISchedulable;

public class Event {
    private EventStatus m_status;
    private IEventId m_id;
    private Date m_scheduledStartTime;
    private Date m_requestedStartTime;
    private BaseClass m_history;
    private BaseClass m_runnable;
    private Integer m_priority;
    private ISchedulable m_schedulable;
    private String m_cancelUser;
    private String m_scheduledBy;
    private boolean m_isOverrideEvent;
    private int position;
    private String tenantID;
    public String duration;

    public Event(EventStatus status, IEventId id) {
        this.m_id = id;
        this.m_requestedStartTime = this.m_scheduledStartTime = id.getRunDate();
        this.m_status = status;
    }

    public EventStatus getStatus() {
        return this.m_status;
    }

    public void setStatus(EventStatus status) {
        this.m_status = status;
    }

    public IEventId getEventId() {
        return this.m_id;
    }

    public Date getRequestedStartDate() {
        return this.m_requestedStartTime;
    }

    public Date getScheduledStartDate() {
        return this.m_scheduledStartTime;
    }

    public Date getRunDate() {
        return this.getRequestedStartDate();
    }

    public void setRequestedStartDate(Date requested) {
        this.m_requestedStartTime = requested;
    }

    public BaseClass getRunnable() {
        return this.m_runnable;
    }

    public void setRunnable(BaseClass runnable) {
        this.m_runnable = runnable;
    }

    public BaseClass getHistory() {
        return this.m_history;
    }

    public void setHistory(BaseClass history) {
        this.m_history = history;
    }

    public Integer getPriority() {
        return this.m_priority;
    }

    public void setPriority(Integer priority) {
        this.m_priority = priority;
    }

    public boolean isDelayed() {
        if (this.m_requestedStartTime != null) {
            return !this.m_scheduledStartTime.equals(this.m_requestedStartTime);
        }
        return false;
    }

    public ISchedulable getSchedulable() {
        return this.m_schedulable;
    }

    public void setSchedulable(ISchedulable schedulable) {
        this.m_schedulable = schedulable;
    }

    public String getCancelUser() {
        return this.m_cancelUser;
    }

    public void setCancelUser(String user) {
        this.m_cancelUser = user;
    }

    public String getScheduledBy() {
        return this.m_scheduledBy;
    }

    public void setScheduledBy(String scheduledBy) {
        this.m_scheduledBy = scheduledBy;
    }

    public boolean isOverride() {
        return this.m_isOverrideEvent;
    }

    public void setIsOverride(boolean isOverride) {
        this.m_isOverrideEvent = isOverride;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public String getTenantID() {
        return this.tenantID;
    }

    public void setTenantID(String tenantID) {
        this.tenantID = tenantID;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Event)) {
            return false;
        }
        Event other = (Event)object;
        return this.m_id.equals(other.m_id);
    }

    public static class RequestDateComparator
    implements Comparator<Event> {
        boolean m_ascending = true;

        public RequestDateComparator() {
        }

        public RequestDateComparator(boolean ascending) {
            this.m_ascending = ascending;
        }

        @Override
        public int compare(Event o1, Event o2) {
            Event event1 = null;
            Event event2 = null;
            if (this.m_ascending) {
                event1 = o1;
                event2 = o2;
            } else {
                event1 = o2;
                event2 = o1;
            }
            int result = 0;
            if (event1.getRunDate() != null && event2.getRunDate() != null) {
                result = event1.getRunDate().compareTo(event2.getRunDate());
            } else if (event1.getRunDate() != null && event2.getRunDate() == null) {
                result = 1;
            } else if (event1.getRunDate() == null && event2.getRunDate() != null) {
                result = -1;
            }
            if (result == 0) {
                result = event1.getScheduledStartDate().compareTo(event2.getScheduledStartDate());
            }
            if (result == 0 && !event1.m_id.equalTo(event2.m_id)) {
                result = -1;
            }
            return result;
        }
    }
}

