/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.event;

import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.sds.event.EventIdUtil;
import com.cognos.sds.event.IEventId;
import java.util.Date;

public class EventId
implements IEventId {
    public static final int GUID_COMPONENT_LENGTH = 32;
    public static final int TIME_COMPONENT_LENGTH = 13;
    private Date m_date;
    private NCObjectId m_id;
    private boolean m_id_known = true;
    private String m_guid_stub;

    public EventId(Date date) {
        this((NCObjectId)null, date);
    }

    public EventId(NCObjectId id) {
        this(id, new Date());
    }

    public EventId(NCObjectId id, Date date) {
        this.m_guid_stub = EventIdUtil.getGuidStub(id);
        this.m_id = id;
        this.m_date = date;
    }

    @Override
    public String toXMLString() {
        return EventIdUtil.makeEventIdString(this.getGuid(), this.getRunDate());
    }

    public String toString() {
        return this.toXMLString();
    }

    @Override
    public Date getRunDate() {
        return this.m_date;
    }

    public void setTaskId(NCObjectId id) {
        this.m_id = id;
        this.m_guid_stub = EventIdUtil.getGuidStub(id);
        this.m_id_known = true;
    }

    @Override
    public NCObjectId getTaskId() {
        if (!this.m_id_known) {
            this.m_id = EventIdUtil.retrievePersistedId(this.m_guid_stub);
            this.m_id_known = true;
        }
        return this.m_id;
    }

    @Override
    public String getGuid() {
        return this.m_guid_stub;
    }

    @Override
    public boolean equalTo(IEventId id) {
        return id.toXMLString().equals(this.toXMLString());
    }

    public boolean equals(Object another) {
        boolean equals = another instanceof EventId;
        equals = equals && this.equalTo((EventId)another);
        return equals;
    }

    public int hashCode() {
        return this.toXMLString().hashCode();
    }

    public static IEventId valueOf(String id) {
        Object event_id = null;
        Date date = null;
        Object ncid = null;
        try {
            Long date_long = Long.valueOf(id.substring(32), 16);
            date = new Date(date_long);
        }
        catch (NumberFormatException date_long) {
            // empty catch block
        }
        String guid = id.substring(0, 32);
        return new EventId(guid, date);
    }

    private EventId(String guid, Date date) {
        this.m_guid_stub = guid;
        this.m_date = date;
        this.m_id_known = false;
    }
}

