/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.event;

import com.cognos.sds.event.EventId;
import com.cognos.sds.event.IEventId;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;

public class EventIdConverter {
    private static final String EVENT_ID = "eventID";
    private static final String VALUE = "value";
    private static final String ITEM = "item";
    private static final String OBJECTS = "objects";
    private static final String EVENT_ID_VALUE = "./eventID/value";
    private static final String EVENT_ID_ARRAY_ITEM = "./objects/item";

    public static void setEventId(Element element, IEventId id) {
        if (element == null || id == null) {
            return;
        }
        Element eventIdElement = DocumentFactory.getInstance().createElement(EVENT_ID);
        Element valueElement = DocumentFactory.getInstance().createElement(VALUE);
        valueElement.setText(id.toXMLString());
        eventIdElement.add(valueElement);
        element.add(eventIdElement);
    }

    public static void setEventId(Element element, IEventId[] ids) {
        if (element == null) {
            return;
        }
        Element objects = DocumentFactory.getInstance().createElement(OBJECTS);
        for (int i = 0; i < ids.length; ++i) {
            Element item = DocumentFactory.getInstance().createElement(ITEM);
            EventIdConverter.setEventId(item, ids[i]);
            objects.add(item);
        }
    }

    public static IEventId getEventId(Node element) {
        if (element == null) {
            return null;
        }
        Node eventIdNode = element.selectSingleNode(EVENT_ID_VALUE);
        String idString = eventIdNode != null ? eventIdNode.getText() : "";
        return EventId.valueOf(idString);
    }

    public static IEventId[] getEventIds(Node element) {
        if (element == null) {
            return new EventId[0];
        }
        ArrayList<IEventId> eventIds = new ArrayList<IEventId>();
        List list = element.selectNodes(EVENT_ID_ARRAY_ITEM);
        for (Node eventIdElement : list) {
            eventIds.add(EventIdConverter.getEventId(eventIdElement));
        }
        IEventId[] ids = new IEventId[eventIds.size()];
        eventIds.toArray(ids);
        return ids;
    }

    public static void main(String[] args) {
        EventIdConverter eventIdConverter1 = new EventIdConverter();
    }
}

