/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.event;

import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailEventID;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.jdbc.util.SqlResourceCloser;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.GuidIdGenerator;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.util.HexFormatter;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.sds.core.persist.PublishedGuidException;
import com.cognos.sds.core.persist.PublishedGuidPersist;
import com.cognos.sds.event.EventId;
import com.cognos.sds.event.IEventId;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public final class EventIdUtil {
    private static IGuidStubRetriever m_stubRetriever = new GuidStubRetriever();

    public static void setIntoStatement(IEventId id, PreparedStatement ps, int index) throws SQLException {
        ps.setString(index, id.toXMLString());
    }

    public static IEventId readFromResultSet(ResultSet rs, int column) throws SQLException {
        String id = rs.getString(column);
        return EventId.valueOf(id);
    }

    public static IEventId readFromResultSet(ResultSet rs, String name) throws SQLException {
        String id = rs.getString(name);
        return EventId.valueOf(id);
    }

    public static Map toXMLStrings(NCObjectId task_id, Date[] run_dates) {
        String stub = EventIdUtil.getGuidStub(task_id);
        int capacity = run_dates.length > 0 ? (int)((double)run_dates.length / 0.75) + 1 : 1;
        Hashtable<Date, String> map = new Hashtable<Date, String>(capacity);
        for (int i = 0; stub != null && i < run_dates.length; ++i) {
            Date date = run_dates[i];
            map.put(date, EventIdUtil.makeEventIdString(stub, date));
        }
        return map;
    }

    public static String getGuidStub(NCObjectId id) {
        String stub = null;
        stub = EventIdUtil.retrievePersistedStub(id);
        if (stub == null) {
            stub = GuidIdGenerator.createNew().toString();
        }
        return stub;
    }

    private static String retrievePersistedStub(NCObjectId id) {
        return m_stubRetriever.retrievePersistedStub(id);
    }

    public static NCObjectId retrievePersistedId(String guid) {
        return m_stubRetriever.retrievePersistedId(guid);
    }

    public static String makeEventIdString(String guid, Date date) {
        String ret_value = guid + (date != null ? HexFormatter.toHex((long)date.getTime(), (int)13) : HexFormatter.toHex((long)new Date().getTime(), (int)13));
        if (ret_value == null || ret_value.length() != 45) {
            throw new RuntimeException(I18NUtil.getMessage((I18NCode)I18NCode.EVENT_ID_INVALID, (Locale)Locale.getDefault()));
        }
        return ret_value;
    }

    public static IEventId createEventId() {
        return new EventId(new Date());
    }

    public static void addEventIDToReply(AsynchReply reply, IEventId id) {
        if (reply == null) {
            return;
        }
        AsynchDetailEventID dei = new AsynchDetailEventID();
        dei.setEventID(id.toXMLString());
        AsynchDetail[] existingDetails = reply.getDetails();
        if (existingDetails == null) {
            reply.setDetails(new AsynchDetail[]{dei});
        } else {
            AsynchDetail[] details = new AsynchDetail[existingDetails.length + 1];
            System.arraycopy(existingDetails, 0, details, 0, existingDetails.length);
            details[existingDetails.length] = dei;
            reply.setDetails(details);
        }
    }

    public static IEventId getEventIDFromReply(AsynchReply reply) {
        IEventId id = null;
        if (reply == null) {
            return null;
        }
        AsynchDetail[] existingDetails = reply.getDetails();
        if (existingDetails != null) {
            for (int i = 0; i < existingDetails.length; ++i) {
                if (!(existingDetails[i] instanceof AsynchDetailEventID)) continue;
                AsynchDetailEventID dei = (AsynchDetailEventID)existingDetails[i];
                id = EventId.valueOf(dei.getEventID());
            }
        }
        return id;
    }

    public static void setStubRetriever(IGuidStubRetriever stubRetriever) {
        m_stubRetriever = stubRetriever;
    }

    public static class GuidStubRetriever
    implements IGuidStubRetriever {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String retrievePersistedStub(NCObjectId id) {
            if (id == null) {
                return null;
            }
            JDBCConnection conn = null;
            String stub = null;
            try {
                conn = NCConnection.instance().getConnectionFactory().createReadOnlyConnection();
                PublishedGuidPersist pgp = PublishedGuidPersist.getInstance();
                stub = pgp.getGuid((Connection)conn, id);
            }
            catch (SQLException e) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)e);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_ERROR_UNABLE_TO_GET_CONNECTION_FROM, (Object[])new String[]{"" + e.getMessage()});
            }
            catch (PublishedGuidException e) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)((Object)e));
            }
            finally {
                SqlResourceCloser.releaseConnection((JDBCConnection)conn);
            }
            return stub;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NCObjectId retrievePersistedId(String guid) {
            if (guid == null) {
                return null;
            }
            JDBCConnection conn = null;
            NCObjectId id = null;
            try {
                conn = NCConnection.instance().getConnectionFactory().createReadOnlyConnection();
                PublishedGuidPersist pgp = PublishedGuidPersist.getInstance();
                id = pgp.getNCObjectId((Connection)conn, guid);
            }
            catch (SQLException e) {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_ERROR_UNABLE_TO_GET_CONNECTION_FROM, (Object[])new String[]{"" + e.getMessage()});
            }
            catch (PublishedGuidException e) {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.MSG_FAILED_TO_RETRIEVE_A_TASK_OBJECT_FROM_RE, (Object[])new String[]{guid});
            }
            finally {
                SqlResourceCloser.releaseConnection((JDBCConnection)conn);
            }
            return id;
        }
    }

    public static interface IGuidStubRetriever {
        public String retrievePersistedStub(NCObjectId var1);

        public NCObjectId retrievePersistedId(String var1);
    }
}

