/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.event;

import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.monitor.api.MonitorServiceException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventTransition {
    private static final Map m_states = new HashMap(15);

    public static void validate(EventStatus current, EventStatus target) throws MonitorServiceException {
        if (current != null && target != null) {
            List allowed = (List)m_states.get(current);
            if (allowed == null || !allowed.contains(target)) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("EventTransition.validate(...) Illegal state change detected");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.EVENT_ILLEGAL_TRANS, (Object[])new String[]{current.statusName(), target.statusName()});
                throw new MonitorServiceException(I18NCode.EVENT_ILLEGAL_TRANS, new Object[]{current.statusMsgCode(), target.statusMsgCode()});
            }
        } else {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("EventTransition.validate(...) Illegal state change detected (a status is null!)");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.EVENT_UPDATE_ERROR);
            throw new MonitorServiceException(I18NCode.EVENT_UPDATE_ERROR);
        }
    }

    static {
        m_states.put(EventStatus.SCHEDULED, Arrays.asList(EventStatus.PENDING, EventStatus.CANCELLED, EventStatus.SUSPENDED));
        m_states.put(EventStatus.CANCELLED, Arrays.asList(EventStatus.SCHEDULED));
        m_states.put(EventStatus.PENDING, Arrays.asList(EventStatus.SCHEDULED, EventStatus.SUSPENDED, EventStatus.PURGED, EventStatus.EXECUTING, EventStatus.CANCELLED, EventStatus.FAILED));
        m_states.put(EventStatus.SUSPENDED, Arrays.asList(EventStatus.SCHEDULED, EventStatus.PURGED, EventStatus.PENDING, EventStatus.CANCELLED));
        m_states.put(EventStatus.EXECUTING, Arrays.asList(EventStatus.TERMINATED, EventStatus.FAILED, EventStatus.SUCCEEDED, EventStatus.CANCELLED, EventStatus.INACTIVE));
        m_states.put(EventStatus.INACTIVE, Arrays.asList(EventStatus.TERMINATED, EventStatus.FAILED, EventStatus.SUCCEEDED, EventStatus.CANCELLED));
        m_states.put(EventStatus.PURGED, Arrays.asList(new EventStatus[0]));
        m_states.put(EventStatus.TERMINATED, Arrays.asList(new EventStatus[0]));
        m_states.put(EventStatus.SUCCEEDED, Arrays.asList(new EventStatus[0]));
        m_states.put(EventStatus.FAILED, Arrays.asList(new EventStatus[0]));
        m_states.put(EventStatus.SDS_NEW, Arrays.asList(EventStatus.PENDING, EventStatus.FAILED, EventStatus.EXECUTING));
    }
}

