/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.event;

import com.cognos.developer.schemas.bibus._3.EventRecord;
import com.cognos.jsmcommon.api.SDSServiceException;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.QueryEventAdapter;
import com.cognos.sds.event.QueryEventResponse;
import com.cognos.sds.handler.ProcessHandlerException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class EventsContext {
    public static final String FUTURE_TRANSIENT_EVENTS = "FUTURE_TRANSIENT_EVENTS";
    public static final String FUTURE_EVENTS = "FUTURE_EVENTS";
    public static final String NON_LOCAL_EVENTS = "NON_LOCAL_EVENTS";
    public static final String LOCAL_CANCEL = "LOCAL_CANCEL";
    public static final String LOCAL_HOLD = "LOCAL_HOLD";
    public static final String LOCAL_RELEASE = "LOCAL_RELASE";
    public static final String ORPHANED_EVENTS = "ORPHANED_EVENTS";
    private Event[] m_events = new Event[0];
    private Integer m_processedEventsCount = new Integer(0);
    private QueryEventAdapter m_queryEventAdapter;
    private QueryEventResponse m_queryEventResponse;
    private List m_query_event_list = new LinkedList();
    private List m_updateEventFaults = new LinkedList();
    private Map m_eventLists = new HashMap();

    public void addToProcessedEventsCount(int count) {
        this.m_processedEventsCount = new Integer(this.m_processedEventsCount + count);
    }

    public void addToQueryEventResponse(EventRecord event) {
        this.m_query_event_list.add(event);
    }

    public void addUpdateEventFault(SDSServiceException fault) {
        this.m_updateEventFaults.add(fault);
    }

    public Event[] getEvents() throws ProcessHandlerException {
        if (this.m_events == null) {
            throw new ProcessHandlerException(I18NCode.OTH_MISSING_CONTEXT_OBJECT, new Object[]{Event.class.getName()});
        }
        return this.m_events;
    }

    public List getEventList(String key) {
        return (List)this.m_eventLists.get(key);
    }

    public int getEventsProcessedCount() throws ProcessHandlerException {
        if (this.m_processedEventsCount == null) {
            throw new ProcessHandlerException(I18NCode.OTH_MISSING_CONTEXT_OBJECT, new Object[]{Integer.class.getName()});
        }
        return this.m_processedEventsCount;
    }

    public QueryEventAdapter getQueryEventAdapter() throws ProcessHandlerException {
        if (this.m_queryEventAdapter == null) {
            throw new ProcessHandlerException(I18NCode.OTH_MISSING_CONTEXT_OBJECT, new Object[]{QueryEventAdapter.class.getName()});
        }
        return this.m_queryEventAdapter;
    }

    public EventRecord[] getQueryEventResponse() throws ProcessHandlerException {
        if (this.m_query_event_list == null) {
            throw new ProcessHandlerException(I18NCode.OTH_MISSING_CONTEXT_OBJECT, new Object[]{EventRecord.class.getName()});
        }
        return this.m_query_event_list.toArray(new EventRecord[this.m_query_event_list.size()]);
    }

    public List getUpdateEventFaults() {
        return this.m_updateEventFaults;
    }

    public QueryEventResponse getQueryEventSDSResponse() {
        return this.m_queryEventResponse;
    }

    public void setEvents(Event[] events) {
        this.m_events = events;
    }

    public void setEventList(String key, List eventList) {
        this.m_eventLists.put(key, eventList);
    }

    public void setQueryEventAdapter(QueryEventAdapter adapter) {
        this.m_queryEventAdapter = adapter;
    }

    public void setQueryEventSDSResponse(QueryEventResponse response) {
        this.m_queryEventResponse = response;
    }
}

