/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.event;

import com.cognos.developer.schemas.bibus._3.EventRefProp;
import com.cognos.developer.schemas.bibus._3.EventRefPropEnum;
import com.cognos.developer.schemas.bibus._3.OrderEnum;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryEventsOptions;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.util.TimeUtils;
import com.cognos.monitor.api.MonitorServiceException;
import java.util.Date;
import java.util.Locale;

public class QueryEventAdapter {
    private QueryEventsOptions m_query;
    public static final String HISTORY = "history";
    public static final String RUNNABLE = "runnable";
    public static final String SCHEDULED_STATE = EventStatus.SCHEDULED.statusName();

    public QueryEventAdapter(QueryEventsOptions query) {
        this.m_query = query;
    }

    public Date getStartDate() throws MonitorServiceException {
        Date date = new Date(System.currentTimeMillis());
        try {
            date = this.m_query.getStartTime().getTime();
        }
        catch (NullPointerException ex) {
            String localizedStart = I18NUtil.getMessage((I18NCode)I18NCode.SCHD_START_KEYWORD, (Locale)Locale.getDefault());
            throw new MonitorServiceException(I18NCode.SCHD_INVALID_DATE, new Object[]{localizedStart});
        }
        return date;
    }

    public void setStartDate(Date date) {
        this.m_query.setStartTime(TimeUtils.dateToUTCJavaCalendar((Date)date));
    }

    public Date getEndDate() throws MonitorServiceException {
        Date date = new Date(System.currentTimeMillis());
        try {
            date = this.m_query.getEndTime().getTime();
        }
        catch (NullPointerException ex) {
            String localizedEnd = I18NUtil.getMessage((I18NCode)I18NCode.SCHD_END_KEYWORD, (Locale)Locale.getDefault());
            throw new MonitorServiceException(I18NCode.SCHD_INVALID_DATE, new Object[]{localizedEnd});
        }
        return date;
    }

    public void setEndDate(Date date) {
        this.m_query.setEndTime(TimeUtils.dateToUTCJavaCalendar((Date)date));
    }

    public int getSkipCount() {
        return this.m_query.getSkipObjects();
    }

    public void setSkipCount(int skip) {
        this.m_query.setSkipObjects(skip);
    }

    public int getMaxReturn() {
        return this.m_query.getMaxObjects();
    }

    public void setMaxReturn(int max) {
        this.m_query.setMaxObjects(max);
    }

    public boolean isAscending() {
        OrderEnum order = this.m_query.getOrder();
        if (null == order) {
            order = OrderEnum.ascending;
        }
        return order.equals((Object)OrderEnum.ascending);
    }

    public void setAscending(boolean ascending) {
        OrderEnum xenum = ascending ? OrderEnum.ascending : OrderEnum.descending;
        this.m_query.setOrder(xenum);
    }

    public String[] getStatuses() {
        return this.m_query.getStatus();
    }

    public void setStatuses(String[] statuses) {
        this.m_query.setStatus(statuses);
    }

    public PropEnum[] getRefProps() {
        PropEnum[] properties = new PropEnum[]{PropEnum.searchPath, PropEnum.defaultName, PropEnum.objectClass};
        return properties;
    }

    public PropEnum[] getRunnableRefProps() {
        PropEnum[] runnableRefProps = null;
        EventRefProp[] eventRefProps = this.m_query.getRefProps();
        if (eventRefProps != null) {
            for (int i = 0; i < eventRefProps.length; ++i) {
                if (!eventRefProps[i].getRefPropName().equals((Object)EventRefPropEnum.runnable)) continue;
                runnableRefProps = eventRefProps[i].getProperties();
                break;
            }
        }
        if (runnableRefProps == null) {
            runnableRefProps = new PropEnum[]{PropEnum.searchPath, PropEnum.defaultName, PropEnum.objectClass};
        }
        return runnableRefProps;
    }
}

