/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.event;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.EventRecord;
import com.cognos.ems.event.FutureEventsContext;
import com.cognos.ems.event.FutureEventsHandlers;
import com.cognos.ems.event.FutureEventsResponse;
import com.cognos.ems.event.SuspendedFutureEventsHandlers;
import com.cognos.jsmcommon.api.APIException;
import com.cognos.jsmcommon.api.ChainedServiceException;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.PerfLog;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.EventsContext;
import com.cognos.sds.event.IEventId;
import com.cognos.sds.event.QueryEventAdapter;
import com.cognos.sds.event.QueryEventHandlers;
import com.cognos.sds.event.UpdateEventStatusHandlers;
import com.cognos.sds.event.UpdateFutureEventsHandlers;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import com.cognos.spec.queryEvent.castor.Filters;
import com.cognos.spec.queryEvent.castor.QueryEventSpecification;
import com.cognos.spec.queryEvent.castor.types.StatusEnum;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import noticecast.datatier.scheduling.JDBCDhTaskScheduleUtil;

public class SDSEventService {
    private static SDSEventService m_instance = new SDSEventService();

    private SDSEventService() {
    }

    public static SDSEventService getInstance() {
        return m_instance;
    }

    public void cancelEvents(IEventId[] eventIDs, BiBusHeader header) throws APIException {
        Event[] events = new Event[eventIDs.length];
        for (int i = 0; i < eventIDs.length; ++i) {
            events[i] = new Event(EventStatus.CANCELLED, eventIDs[i]);
            Event existingEvent = JDBCDhTaskScheduleUtil.getOverrideEvent(eventIDs[i]);
            if (existingEvent == null) continue;
            events[i].setIsOverride(true);
            events[i].setRequestedStartDate(existingEvent.getRequestedStartDate());
        }
        this.updateStatus(events, header);
    }

    public void releaseEvents(IEventId[] eventIDs, BiBusHeader header) throws APIException {
        Event[] events = new Event[eventIDs.length];
        for (int i = 0; i < eventIDs.length; ++i) {
            if (JDBCDhTaskScheduleUtil.isOverrideEvent(eventIDs[i])) {
                events[i] = new Event(EventStatus.SCHEDULED, eventIDs[i]);
                events[i].setIsOverride(true);
                continue;
            }
            events[i] = new Event(EventStatus.PENDING, eventIDs[i]);
        }
        this.updateStatus(events, header);
    }

    public void scheduleEvents(IEventId[] eventIDs, BiBusHeader header) throws APIException {
        Event[] events = new Event[eventIDs.length];
        for (int i = 0; i < eventIDs.length; ++i) {
            events[i] = new Event(EventStatus.SCHEDULED, eventIDs[i]);
            Event existingEvent = JDBCDhTaskScheduleUtil.getOverrideEvent(eventIDs[i]);
            if (existingEvent == null) continue;
            events[i].setIsOverride(true);
            events[i].setRequestedStartDate(existingEvent.getRequestedStartDate());
        }
        this.updateStatus(events, header);
    }

    public void updateEvents(Event[] events, BiBusHeader header) throws APIException {
        EventsContext eventsContext = new EventsContext();
        eventsContext.setEventList("FUTURE_EVENTS", Arrays.asList(events));
        ProcessContext context = new ProcessContext();
        context.setEventContext(eventsContext);
        context.setBiBusHeader(header);
        try {
            Iterator handlers = UpdateFutureEventsHandlers.getInstance().getHandlers().iterator();
            while (handlers.hasNext()) {
                ((ProcessHandler)handlers.next()).invoke(context);
            }
            List faults = context.getEventsContext().getUpdateEventFaults();
            if (faults.size() > 0) {
                ChainedServiceException ex = new ChainedServiceException(faults);
                throw new APIException((LocalizableException)ex);
            }
        }
        catch (ProcessHandlerException ex) {
            throw new APIException((LocalizableException)((Object)ex));
        }
    }

    public int updateStatus(Event[] events, BiBusHeader header) throws APIException {
        EventsContext eventsContext = new EventsContext();
        eventsContext.setEvents(events);
        ProcessContext context = new ProcessContext();
        context.setEventContext(eventsContext);
        context.setBiBusHeader(header);
        int updates = 0;
        try {
            Iterator handlers = UpdateEventStatusHandlers.getInstance().getHandlers().iterator();
            while (handlers.hasNext()) {
                ((ProcessHandler)handlers.next()).invoke(context);
            }
            updates = context.getEventsContext().getEventsProcessedCount();
            List faults = context.getEventsContext().getUpdateEventFaults();
            if (faults.size() > 0) {
                ChainedServiceException ex = new ChainedServiceException(faults);
                throw new APIException((LocalizableException)ex);
            }
        }
        catch (ProcessHandlerException ex) {
            throw new APIException((LocalizableException)((Object)ex));
        }
        return updates;
    }

    public EventRecord[] queryEvents(QueryEventAdapter query, BiBusHeader header) throws APIException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSMCommonCategory.PERF).start(this.getClass(), SDSLevel.WARN, "CALL");
        EventsContext eventsContext = new EventsContext();
        eventsContext.setQueryEventAdapter(query);
        ProcessContext context = new ProcessContext();
        context.setEventContext(eventsContext);
        context.setBiBusHeader(header);
        EventRecord[] events = new EventRecord[]{};
        try {
            Iterator handlers = QueryEventHandlers.getInstance().getHandlers().iterator();
            while (handlers.hasNext()) {
                ((ProcessHandler)handlers.next()).invoke(context);
            }
            events = context.getEventsContext().getQueryEventResponse();
        }
        catch (ProcessHandlerException ex) {
            throw new APIException((LocalizableException)((Object)ex));
        }
        finally {
            perf.stop();
        }
        return events;
    }

    public FutureEventsResponse getEventRecords(FutureEventsContext context, BiBusHeader header) throws APIException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSMCommonCategory.PERF).start(this.getClass(), SDSLevel.WARN, "CALL");
        FutureEventsResponse response = null;
        try {
            ProcessContext processContext = new ProcessContext();
            processContext.setFutureEventsContext(context);
            processContext.setBiBusHeader(header);
            Iterator handlers = null;
            QueryEventSpecification spec = context.getQuerySpecification();
            Filters filters = spec.getFilters();
            handlers = filters != null && filters.getStatus() != null && filters.getStatus().equals(StatusEnum.SUSPENDED) ? SuspendedFutureEventsHandlers.getInstance().getHandlers().iterator() : FutureEventsHandlers.getInstance().getHandlers().iterator();
            while (handlers.hasNext()) {
                ((ProcessHandler)handlers.next()).invoke(processContext);
            }
            response = processContext.getFutureEventsContext().getFutureEventsResponse();
        }
        catch (ProcessHandlerException ex) {
            throw new APIException((LocalizableException)((Object)ex));
        }
        finally {
            perf.stop();
        }
        return response;
    }
}

