/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.event.handlers;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.monitor.api.MonitorServiceException;
import com.cognos.monitor.impl.EventResultType;
import com.cognos.monitor.impl.EventsResult;
import com.cognos.monitor.impl.MonitorService;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.EventsContext;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import java.util.ArrayList;
import java.util.List;
import noticecast.services.soap.cm.CMAssistor;

public class CancelEventsHandler
implements ProcessHandler {
    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        EventsContext eventsContext = context.getEventsContext();
        List events = eventsContext.getEventList("LOCAL_CANCEL");
        if (events.size() == 0) {
            return;
        }
        CMAssistor assistor = new CMAssistor();
        String userName = assistor.getUserName(context.getUserAccount());
        int cancelCount = 0;
        MonitorService service = MonitorService.instance();
        EventsResult result = null;
        try {
            result = service.cancelEvents(events.toArray(new Event[events.size()]), userName);
        }
        catch (MonitorServiceException e) {
            eventsContext.addUpdateEventFault(new ProcessHandlerException(I18NCode.EVENT_UNABLE_CANCEL, (LocalizableException)((Object)e)));
        }
        if (result != null) {
            cancelCount += result.getResultsCount(EventResultType.CANCEL_SUCCEEDED);
            eventsContext.addToProcessedEventsCount(cancelCount += result.getResultsCount(EventResultType.CANCEL_FAILED));
            List<Event> nonLocalEventResults = result.getResults(EventResultType.CANCEL_NON_LOCAL);
            if (nonLocalEventResults != null) {
                ArrayList<Event> nonLocalEvents = eventsContext.getEventList("NON_LOCAL_EVENTS");
                if (nonLocalEvents == null) {
                    nonLocalEvents = new ArrayList<Event>();
                    eventsContext.setEventList("NON_LOCAL_EVENTS", nonLocalEvents);
                }
                nonLocalEvents.addAll(nonLocalEventResults);
            }
        }
    }
}

