/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.event.handlers;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.Schedule;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.EventsContext;
import com.cognos.sds.event.handlers.EventHandlerBase;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandlerException;
import com.cognos.sds.security.FutureEventSecurityHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import noticecast.services.soap.cm.CMSearchPathGenerator;

public class EventScheduleRetrieveHandler
extends EventHandlerBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        EventsContext eventsContext = context.getEventsContext();
        FutureEventSecurityHandler fesh = new FutureEventSecurityHandler();
        boolean checkObjectPermissions = fesh.isObjectPermissionsRequired();
        if (context.hasCanUseMonitorActivyToolCapability() && !checkObjectPermissions) {
            return;
        }
        Schedule[] schedules = new Schedule[]{};
        List events = eventsContext.getEventList("FUTURE_EVENTS");
        if (events.size() > 0) {
            ProcessHandlerException phe;
            ContentManagerServiceClientPort cm = null;
            Object classes = null;
            try {
                BiBusHeader header = context.getBiBusHeader();
                cm = Client.instance().getContentManagerServiceClient(new JobBiBusHeaders(header));
                QueryRequest[] request = this.buildRequest(events);
                QueryReply[] reply = cm.queryMultiple(request);
                schedules = this.processReply(reply);
            }
            catch (EMFSecurityException e) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("EventScheduleRetrieveHandler.invoke(): Service Exception retrieving cached binding port.");
                phe = new ProcessHandlerException(I18NCode.IO_CM_COMMS_ERROR);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, (LocalizableException)((Object)phe));
                eventsContext.addUpdateEventFault(phe);
            }
            catch (SDKClientException e) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("EventScheduleRetrieveHandler.invoke(): SDKClient Exception retrieving schedule information.");
                phe = new ProcessHandlerException(I18NCode.IO_CM_COMMS_ERROR, (LocalizableException)((Object)e));
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, (LocalizableException)((Object)phe));
                eventsContext.addUpdateEventFault(phe);
            }
            catch (Throwable e) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("EventScheduleRetrieveHandler.invoke(): Error retrieving schedule information.[" + e.getLocalizedMessage() + "]");
                phe = new ProcessHandlerException(I18NCode.GEN_THROWABLE_ERROR, new String[]{e.getLocalizedMessage()});
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, (LocalizableException)((Object)phe));
                eventsContext.addUpdateEventFault(phe);
            }
            finally {
                if (cm != null) {
                    cm.close();
                }
            }
        }
        Map eventMap = this.buildListMap(eventsContext.getEventList("FUTURE_EVENTS"));
        ArrayList<String> guids = new ArrayList<String>();
        for (int i = 0; i < schedules.length; ++i) {
            guids.add(schedules[i].getTaskID().getValue());
        }
        if (this.filterListMap(eventMap, guids)) {
            eventsContext.addUpdateEventFault(new ProcessHandlerException(I18NCode.SEC_NO_PRIVELEDGES));
        }
        eventsContext.setEventList("FUTURE_EVENTS", this.getEvents(eventMap));
        context.setSchedules(schedules);
    }

    private QueryRequest[] buildRequest(List events) {
        QueryRequest[] request = new QueryRequest[events.size()];
        PropEnum[] props = new PropEnum[]{PropEnum.credential, PropEnum.taskID};
        Iterator itr = events.iterator();
        int i = 0;
        while (itr.hasNext()) {
            Event next = (Event)itr.next();
            String path = CMSearchPathGenerator.getSchedule(next.getEventId().getGuid());
            request[i] = new QueryRequest();
            request[i].setSearch(path);
            request[i].setProperties(props);
            ++i;
        }
        return request;
    }

    private Schedule[] processReply(QueryReply[] reply) {
        ArrayList<Schedule> schedulesList = new ArrayList<Schedule>();
        for (int i = 0; i < reply.length; ++i) {
            BaseClass[] result = reply[i].getQueryResult();
            if (result == null || result.length <= 0) continue;
            schedulesList.add((Schedule)result[0]);
        }
        return schedulesList.toArray(new Schedule[schedulesList.size()]);
    }
}

