/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.event.handlers;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.monitor.api.MonitorServiceException;
import com.cognos.monitor.impl.MonitorService;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.EventsContext;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import java.util.List;
import noticecast.services.soap.cm.CMAssistor;

public class HoldEventsHandler
implements ProcessHandler {
    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        EventsContext eventsContext = context.getEventsContext();
        List events = eventsContext.getEventList("LOCAL_HOLD");
        if (events.size() == 0) {
            return;
        }
        CMAssistor assistor = new CMAssistor();
        String userName = assistor.getUserName(context.getUserAccount());
        MonitorService service = MonitorService.instance();
        int holdCount = 0;
        try {
            holdCount = service.suspendEvents(events.toArray(new Event[events.size()]), userName);
        }
        catch (MonitorServiceException e) {
            ProcessHandlerException phe = new ProcessHandlerException(I18NCode.EVENT_UNABLE_HOLD, (LocalizableException)((Object)e));
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, (LocalizableException)((Object)e));
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, (LocalizableException)((Object)phe));
            eventsContext.addUpdateEventFault(phe);
        }
        eventsContext.addToProcessedEventsCount(holdCount);
    }
}

