/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.event.handlers;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.Nil;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.ems.i18n.EmsI18NCode;
import com.cognos.ems.util.EMSUtil;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.PerfLog;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.security.UserIdentity;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.monitor.api.MonitorServiceException;
import com.cognos.sds.core.persist.PublishedGuidException;
import com.cognos.sds.core.persist.PublishedGuidPersist;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.EventId;
import com.cognos.sds.event.EventsContext;
import com.cognos.sds.event.QueryEventAdapter;
import com.cognos.sds.event.QueryEventResponse;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import com.cognos.sds.security.FutureEventSecurityHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import noticecast.datatier.helperoptions.HelperOption;
import noticecast.datatier.helperoptions.HelperOptionImpl;
import noticecast.logictier.NCObjectType;
import noticecast.persist.IPersistManager;
import noticecast.persist.PersistManagerException;
import noticecast.scheduling.core.IQueueEntry;
import noticecast.scheduling.core.ISchedulable;
import noticecast.scheduling.core.ISchedulableId;
import noticecast.scheduling.core.SchedulableQuery;
import noticecast.scheduling.core.SchedulableQueryResponse;
import noticecast.scheduling.core.Scheduler;
import noticecast.scheduling.core.SchedulerQueueException;
import noticecast.scheduling.nc.ITaskSchedule;
import noticecast.scheduling.nc.NCSchedulable;
import noticecast.services.RepositoryServicesImpl;
import noticecast.services.soap.cm.CMRunnablePathResolver;
import noticecast.services.soap.cm.CMSearchPathGenerator;

public class QueryEventScheduledHandler
implements ProcessHandler {
    QueryEventAdapter m_adapter;
    BiBusHeader m_header;
    boolean hasCanUseMonitorActivityToolCapability = false;
    boolean mustCheckPermissions = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        block17: {
            EventsContext eventsContext = context.getEventsContext();
            QueryEventResponse queryEventsResponse = new QueryEventResponse();
            eventsContext.setQueryEventSDSResponse(queryEventsResponse);
            this.m_adapter = eventsContext.getQueryEventAdapter();
            this.m_header = context.getBiBusHeader();
            try {
                this.hasCanUseMonitorActivityToolCapability = AuthenticatorFactory.getInstance().hasCapability(this.m_header, UserCapabilityEnum.canUseMonitorActivityTool);
                FutureEventSecurityHandler fesh = new FutureEventSecurityHandler();
                this.mustCheckPermissions = fesh.isObjectPermissionsRequired();
            }
            catch (Exception fesh) {
                // empty catch block
            }
            Date now = new Date();
            try {
                if (this.m_adapter.getEndDate().before(now)) {
                    return;
                }
            }
            catch (MonitorServiceException e) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, (LocalizableException)((Object)e));
                throw new ProcessHandlerException(I18NCode.IO_INVALID_XML, (LocalizableException)((Object)e));
            }
            PerfLog perf = SDSLogger.getLogger((SDSCategory)JSMCommonCategory.PERF).start(this.getClass(), SDSLevel.DEBUG, "BEGIN");
            try {
                SchedulableQueryResponse schedulableQueryResponse;
                Collection schedulables;
                Date start;
                try {
                    start = this.m_adapter.getStartDate().after(now) ? this.m_adapter.getStartDate() : now;
                }
                catch (MonitorServiceException e) {
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, (LocalizableException)((Object)e));
                    throw new ProcessHandlerException(I18NCode.IO_INVALID_XML, (LocalizableException)((Object)e));
                }
                try {
                    schedulables = this.getSchedulables(start, this.m_adapter.getEndDate());
                }
                catch (MonitorServiceException e) {
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, (LocalizableException)((Object)e));
                    throw new ProcessHandlerException(I18NCode.IO_INVALID_XML, (LocalizableException)((Object)e));
                }
                catch (SchedulerQueueException e) {
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, (LocalizableException)e);
                    throw new ProcessHandlerException(EmsI18NCode.MSG_EMS_GENERAL_ERROR, new Object[]{e.getMessage()}, e);
                }
                if (!this.hasCanUseMonitorActivityToolCapability) {
                    EMSUtil emsUtil = new EMSUtil();
                    emsUtil.filterOnCaller(this.m_header, schedulables);
                }
                if (schedulables.size() <= 0) break block17;
                Map runable_map = this.getRunableMap(schedulables.iterator());
                ISchedulable[] schedulableArray = new ISchedulable[runable_map.size()];
                runable_map.keySet().toArray(schedulableArray);
                try {
                    schedulableQueryResponse = SchedulableQuery.doQuery(schedulableArray, start, this.m_adapter.getEndDate(), this.m_adapter.getMaxReturn(), this.m_adapter.getSkipCount(), this.m_adapter.isAscending(), this.m_adapter.getStatuses());
                }
                catch (LocalizableException e) {
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, e);
                    throw new ProcessHandlerException(e.getI18NCode(), e.getParams());
                }
                Event[] runDates = schedulableQueryResponse.getRunDates();
                Event[] events = new Event[runDates.length];
                for (int i = 0; i < runDates.length; ++i) {
                    Date requestRunDate = runDates[i].getRunDate();
                    NCSchedulable ncSchedulable = (NCSchedulable)runDates[i].getSchedulable();
                    EventId eid = new EventId(ncSchedulable.getTaskSchedule().getTaskId(), requestRunDate);
                    BaseClass runable = (BaseClass)runable_map.get(ncSchedulable);
                    events[i] = new Event(runDates[i].getStatus(), eid);
                    events[i].setRequestedStartDate(requestRunDate);
                    events[i].setRunnable(runable);
                }
                queryEventsResponse.updateSkipped(schedulableQueryResponse.getSkipped());
                queryEventsResponse.addEvents(events);
            }
            finally {
                perf.stop();
            }
        }
    }

    private Collection getSchedulables(Date start, Date end) throws SchedulerQueueException {
        Iterator contentsIter;
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSMCommonCategory.PERF).start(this.getClass(), SDSLevel.DEBUG, "ENTER");
        try {
            UserIdentity userIdentity = AuthenticatorFactory.getInstance().getUserIdentity(this.m_header);
            contentsIter = userIdentity.doTenantFiltering() ? Scheduler.getInstance().schedulerQueueContents(userIdentity.getTenantIDsForFiltering(), end).iterator() : Scheduler.getInstance().schedulerQueueContents(end).iterator();
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, (Throwable)e);
            contentsIter = Scheduler.getInstance().schedulerQueueContents(new String[]{""}, end).iterator();
        }
        HashMap<ISchedulableId, IQueueEntry> schedulableIdEntryMap = new HashMap<ISchedulableId, IQueueEntry>();
        while (contentsIter.hasNext()) {
            IQueueEntry entry = (IQueueEntry)contentsIter.next();
            schedulableIdEntryMap.put(entry.getSchedulableId(), entry);
        }
        ISchedulableId[] ids = new ISchedulableId[schedulableIdEntryMap.keySet().size()];
        schedulableIdEntryMap.keySet().toArray(ids);
        Collection schedulables = this.getSchedulablesFromPersistManager(ids);
        Iterator schedulablesIter = schedulables.iterator();
        while (schedulablesIter.hasNext()) {
            ISchedulable schedulable = (ISchedulable)schedulablesIter.next();
            IQueueEntry entry = (IQueueEntry)schedulableIdEntryMap.get(schedulable.getId());
            if (!entry.getDate().before(start)) continue;
            Event runDate = schedulable.getNextExecuteInclusive(start);
            if (runDate != null) {
                Date nextExecute = runDate.getRunDate();
                if (nextExecute != null && !nextExecute.after(end)) continue;
                schedulablesIter.remove();
                continue;
            }
            schedulablesIter.remove();
        }
        perf.stop();
        return schedulables;
    }

    private Collection getSchedulablesFromPersistManager(ISchedulableId[] ids) {
        LinkedList<NCSchedulable> schedulables = new LinkedList<NCSchedulable>();
        HelperOption helperOption = HelperOptionImpl.getHelperOptionForIds(NCObjectType.TASK_SCHEDULE, ids);
        if (helperOption != null) {
            IPersistManager persistManager = RepositoryServicesImpl.instance().getPersistManager();
            try {
                Iterator schedulableIter = persistManager.getObjectList(NCObjectType.TASK_SCHEDULE, null, helperOption);
                while (schedulableIter.hasNext()) {
                    ITaskSchedule taskSchedule = (ITaskSchedule)schedulableIter.next();
                    NCSchedulable schedulable = new NCSchedulable(taskSchedule);
                    schedulables.add(schedulable);
                }
            }
            catch (PersistManagerException persistManagerException) {
                // empty catch block
            }
        }
        return schedulables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getRunableMap(Iterator schedule_itr) throws ProcessHandlerException {
        HashMap<NCSchedulable, Object> runable_map = new HashMap<NCSchedulable, Object>();
        ArrayList<NCObjectId> task_id_array = new ArrayList<NCObjectId>();
        ArrayList schedulable_array = new ArrayList();
        if (schedule_itr == null) {
            return runable_map;
        }
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSMCommonCategory.PERF).start(this.getClass(), SDSLevel.DEBUG, "ENTER");
        try {
            while (schedule_itr.hasNext()) {
                Object next = schedule_itr.next();
                if (!(next instanceof NCSchedulable)) continue;
                NCObjectId task_id = ((NCSchedulable)next).getTaskSchedule().getTaskId();
                task_id_array.add(task_id);
                schedulable_array.add(next);
            }
            NCObjectId[] task_ids = task_id_array.toArray(new NCObjectId[0]);
            NCSchedulable[] schedulables = schedulable_array.toArray(new NCSchedulable[0]);
            BaseClass[] parents = this.getTaskParents(task_ids);
            Locale locale = null;
            for (int i = 0; i < parents.length; ++i) {
                if (parents[i] != null) {
                    runable_map.put(schedulables[i], parents[i]);
                    continue;
                }
                if (!this.hasCanUseMonitorActivityToolCapability || this.mustCheckPermissions) continue;
                Nil runnable = new Nil();
                if (locale == null) {
                    locale = new JobBiBusHeaders(this.m_header).getProductLocale();
                }
                String unknown = I18NUtil.getMessage((I18NCode)I18NCode.KEY_UNKNOWN, null, (Locale)LocaleUtil.createProductLocale((String)locale.toString()));
                TokenProp nameProp = new TokenProp();
                nameProp.setValue(unknown);
                runnable.setDefaultName(nameProp);
                runable_map.put(schedulables[i], runnable);
            }
        }
        finally {
            perf.stop();
        }
        return runable_map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseClass[] getTaskParents(NCObjectId[] task_ids) throws ProcessHandlerException {
        int i;
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSMCommonCategory.PERF).start(this.getClass(), SDSLevel.DEBUG, "ENTER");
        String[] paths = new String[task_ids.length];
        for (i = 0; i < task_ids.length; ++i) {
            try {
                paths[i] = PublishedGuidPersist.getInstance().getGuid(task_ids[i], NCObjectType.NOTIFICATION_AGENT);
                continue;
            }
            catch (PublishedGuidException publishedGuidException) {
                // empty catch block
            }
        }
        for (i = 0; i < paths.length; ++i) {
            paths[i] = paths[i] != null ? CMSearchPathGenerator.getScheduleParent(paths[i]) : CMRunnablePathResolver.getRunnablePath(task_ids[i]);
        }
        BaseClass[] ret_value = new BaseClass[task_ids.length];
        try {
            QueryReply[] cm_responses = this.getRunnablesFromCM(paths);
            for (int i2 = 0; i2 < task_ids.length; ++i2) {
                BaseClass[] response = cm_responses[i2].getQueryResult();
                ret_value[i2] = response != null && response.length >= 1 ? response[0] : null;
            }
        }
        finally {
            perf.stop();
        }
        return ret_value;
    }

    private QueryReply[] getRunnablesFromCM(String[] searchPaths) throws ProcessHandlerException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSMCommonCategory.PERF).start(this.getClass(), SDSLevel.DEBUG, "ENTER");
        QueryRequest[] requests = new QueryRequest[searchPaths.length];
        QueryReply[] ret_value = null;
        QueryOptions qo = new QueryOptions();
        qo.setPermission("read");
        String sPermissionFlag = "[permission('read')]";
        for (int i = 0; i < searchPaths.length; ++i) {
            requests[i] = new QueryRequest();
            if (searchPaths[i] == null) {
                searchPaths[i] = "~/report[@name='data']";
            }
            requests[i].setSearch(searchPaths[i] + sPermissionFlag);
            requests[i].setProperties(this.m_adapter.getRunnableRefProps());
        }
        ContentManagerServiceClientPort cm = null;
        try {
            cm = Client.instance().getContentManagerServiceClient(new JobBiBusHeaders(this.m_header));
            ret_value = cm.queryMultiple(requests);
        }
        catch (EMFSecurityException e) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.MSG_UNABLE_CONNECT_CM);
            throw new ProcessHandlerException(I18NCode.MSG_UNABLE_CONNECT_CM);
        }
        catch (SDKClientException e) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, (LocalizableException)((Object)e));
            ProcessHandlerException phe = new ProcessHandlerException(I18NCode.GEN_3RD_PARTY_FAULT, new String[]{e.getMessage()}, (LocalizableException)((Object)e));
            throw phe;
        }
        finally {
            if (cm != null) {
                cm.close();
            }
            perf.stop();
        }
        return ret_value;
    }
}

