/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.event.handlers;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.serverinst.SDSInstance;
import com.cognos.jsmcommon.serverinst.SDSInstanceManager;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.monitor.util.HistoryHelper;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.EventsContext;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import java.util.ArrayList;
import java.util.Date;

public class SortEventsHandler
implements ProcessHandler {
    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        EventsContext eventsContext = context.getEventsContext();
        Event[] allEvents = eventsContext.getEvents();
        Date now = new Date();
        eventsContext.setEventList("FUTURE_EVENTS", new ArrayList());
        eventsContext.setEventList("NON_LOCAL_EVENTS", new ArrayList());
        eventsContext.setEventList("LOCAL_CANCEL", new ArrayList());
        eventsContext.setEventList("LOCAL_HOLD", new ArrayList());
        eventsContext.setEventList("LOCAL_RELASE", new ArrayList());
        eventsContext.setEventList("ORPHANED_EVENTS", new ArrayList());
        for (int i = 0; i < allEvents.length; ++i) {
            Event event = allEvents[i];
            this.assertStatus(event.getStatus());
            if (event.getEventId().getTaskId() != null && (event.isOverride() || event.getScheduledStartDate().after(now))) {
                eventsContext.getEventList("FUTURE_EVENTS").add(event);
                continue;
            }
            this.processEvent(eventsContext, event);
        }
    }

    private boolean processEvent(EventsContext eventsContext, Event event) throws ProcessHandlerException {
        boolean isLocal = false;
        TaskRecord task = null;
        TaskStateRecord state = null;
        try {
            task = TaskPersistLayer.getTaskFromEventId((String)event.getEventId().toXMLString());
            state = TaskPersistLayer.getTaskStateFromEventId((String)event.getEventId().toXMLString());
        }
        catch (TaskPersistLayerException e1) {
            e1.printStackTrace();
        }
        EventStatus curStatus = task == null ? HistoryHelper.getHistoryStatus(event.getEventId()) : TaskStatus.mapStatus((TaskStatus)state.status);
        SDSInstanceManager sdsInstanceManager = SDSInstanceManager.getInstance();
        if (task != null) {
            SDSInstance thisSDSInstance = sdsInstanceManager.getThisInstance();
            isLocal = task.getSdsInstanceId() == null || task.getSdsInstanceId().equals(thisSDSInstance.getGuid());
            if (isLocal) {
                if (event.getStatus().equals((Object)EventStatus.CANCELLED) || event.getStatus().equals((Object)EventStatus.PURGED) || event.getStatus().equals((Object)EventStatus.TERMINATED)) {
                    eventsContext.getEventList("LOCAL_CANCEL").add(event);
                } else if (event.getStatus().equals((Object)EventStatus.SUSPENDED)) {
                    eventsContext.getEventList("LOCAL_HOLD").add(event);
                } else if (event.getStatus().equals((Object)EventStatus.PENDING)) {
                    eventsContext.getEventList("LOCAL_RELASE").add(event);
                }
            } else {
                eventsContext.getEventList("NON_LOCAL_EVENTS").add(event);
            }
        } else if (curStatus != null) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("SortEventsHandler.isLocal(): No current running event found with ID [" + event.getEventId().toXMLString() + "].");
            curStatus = HistoryHelper.getHistoryStatus(event.getEventId());
            if (EventStatus.SUCCEEDED.isEqualTo(curStatus)) {
                I18NCode eventStatusCode = event.getStatus() != null ? event.getStatus().statusMsgCode() : null;
                ProcessHandlerException phe = new ProcessHandlerException(I18NCode.EVENT_ILLEGAL_TRANS, new Object[]{curStatus.statusMsgCode(), eventStatusCode});
                eventsContext.addUpdateEventFault(phe);
            } else {
                eventsContext.getEventList("ORPHANED_EVENTS").add(event);
            }
        }
        return isLocal;
    }

    private void assertStatus(EventStatus status) throws ProcessHandlerException {
        if (status == null) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug("SortEventsHandler.assertStatus(EventStatus : null) - User cannot update status to null!");
            throw new ProcessHandlerException(I18NCode.EVENT_UPDATE_ERROR);
        }
        if (status.isEqualTo(EventStatus.FAILED) || status.isEqualTo(EventStatus.EXECUTING) || status.isEqualTo(EventStatus.SUCCEEDED)) {
            String statusString = status.statusName();
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug("SortEventsHandler.assertStatus(EventStatus : " + statusString + ") - User cannot update status to  " + statusString + "!");
            ProcessHandlerException phe = new ProcessHandlerException(I18NCode.EVENT_ILLEGAL_TARGET_TRANS, new String[]{status.statusName()});
            throw new ProcessHandlerException(I18NCode.EVENT_UPDATE_ERROR, (LocalizableException)((Object)phe));
        }
    }
}

