/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.event.handlers;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.NmtokenArrayProp;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.EventsContext;
import com.cognos.sds.event.handlers.EventHandlerBase;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandlerException;
import com.cognos.sds.security.FutureEventSecurityHandler;
import com.cognos.sds.util.EventsUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TransientEventScheduleRetrieveHandler
extends EventHandlerBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        EventsContext eventsContext = context.getEventsContext();
        FutureEventSecurityHandler fesh = new FutureEventSecurityHandler();
        boolean checkObjectPermissions = fesh.isObjectPermissionsRequired();
        if (context.hasCanUseMonitorActivyToolCapability() && !checkObjectPermissions) {
            return;
        }
        List allEvents = eventsContext.getEventList("FUTURE_EVENTS");
        List transientFutureEvents = EventsUtil.getTransientFutureEvents(eventsContext);
        if (transientFutureEvents.size() <= 0) {
            return;
        }
        ArrayList<Event> nonTransientFutureEvents = null;
        if (allEvents.size() > 0) {
            for (Event event : allEvents) {
                if (((List)transientFutureEvents.get(0)).contains(event)) continue;
                if (nonTransientFutureEvents == null) {
                    nonTransientFutureEvents = new ArrayList<Event>();
                }
                nonTransientFutureEvents.add(event);
            }
            ContentManagerServiceClientPort cm = null;
            try {
                QueryReply[] reply;
                BiBusHeader header = context.getBiBusHeader();
                cm = Client.instance().getContentManagerServiceClient(new JobBiBusHeaders(header));
                QueryRequest[] request = this.buildRequest((List)transientFutureEvents.get(1));
                if (request != null && request.length > 0 && this.filteredEventsByPermissions(transientFutureEvents, reply = cm.queryMultiple(request))) {
                    eventsContext.addUpdateEventFault(new ProcessHandlerException(I18NCode.SEC_NO_PRIVELEDGES));
                }
            }
            catch (EMFSecurityException e) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("EventScheduleRetrieveHandler.invoke(): Service Exception retrieving cached binding port.");
                ProcessHandlerException phe = new ProcessHandlerException(I18NCode.IO_CM_COMMS_ERROR);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, (LocalizableException)((Object)phe));
                eventsContext.addUpdateEventFault(phe);
            }
            catch (SDKClientException e) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("EventScheduleRetrieveHandler.invoke(): SDKClient Exception retrieving schedule information.");
                ProcessHandlerException phe = new ProcessHandlerException(I18NCode.IO_CM_COMMS_ERROR, (LocalizableException)((Object)e));
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, (LocalizableException)((Object)phe));
                eventsContext.addUpdateEventFault(phe);
            }
            catch (Throwable e) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("EventScheduleRetrieveHandler.invoke(): Error retrieving schedule information.[" + e.getLocalizedMessage() + "]");
                ProcessHandlerException phe = new ProcessHandlerException(I18NCode.GEN_THROWABLE_ERROR, new String[]{e.getLocalizedMessage()});
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, (LocalizableException)((Object)phe));
                eventsContext.addUpdateEventFault(phe);
            }
            finally {
                if (cm != null) {
                    cm.close();
                }
            }
        }
        Map nonTransientFutureEventMap = this.buildListMap(nonTransientFutureEvents);
        Map transientFutureEventMap = this.buildListMap((List)transientFutureEvents.get(0));
        eventsContext.setEventList("FUTURE_EVENTS", this.getEvents(nonTransientFutureEventMap));
        eventsContext.setEventList("FUTURE_TRANSIENT_EVENTS", this.getEvents(transientFutureEventMap));
    }

    private QueryRequest[] buildRequest(List<String> paths) {
        QueryRequest[] request = new QueryRequest[paths.size()];
        PropEnum[] props = new PropEnum[]{PropEnum.credential, PropEnum.permissions};
        Iterator<String> itr = paths.iterator();
        int i = 0;
        while (itr.hasNext()) {
            String nextPath = itr.next();
            request[i] = new QueryRequest();
            request[i].setSearch(nextPath);
            request[i].setProperties(props);
            ++i;
        }
        return request;
    }

    private boolean filteredEventsByPermissions(List transientFutureEventPaths, QueryReply[] reply) {
        boolean bfiltered = false;
        boolean bexecute = false;
        for (int i = 0; i < reply.length; ++i) {
            NmtokenArrayProp permissions;
            BaseClass[] result = reply[i].getQueryResult();
            if (result == null || result.length <= 0 || (permissions = result[0].getPermissions()) == null || permissions.getValue() == null) continue;
            String[] values = permissions.getValue();
            bexecute = false;
            for (int j = 0; j < values.length; ++j) {
                if (!values[j].equals("execute")) continue;
                bexecute = true;
                break;
            }
            if (values.length > 0 && bexecute) continue;
            ((List)transientFutureEventPaths.get(0)).remove(i);
            ((List)transientFutureEventPaths.get(1)).remove(i);
            bfiltered = true;
        }
        return bfiltered;
    }
}

