/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.event.handlers;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.ConversationContext;
import com.cognos.developer.schemas.bibus._3.Dispatcher_Type;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.serverinst.SDSInstance;
import com.cognos.jsmcommon.serverinst.SDSInstanceManager;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.EventManagementServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.SoapActionHelper;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.EventsContext;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

public class UpdateNonLocalEventsHandler
implements ProcessHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        EventsContext eventsContext = context.getEventsContext();
        List events = eventsContext.getEventList("NON_LOCAL_EVENTS");
        if (events.size() == 0) {
            return;
        }
        SDSInstanceManager sdsInstanceManager = SDSInstanceManager.getInstance();
        BiBusHeader header = context.getBiBusHeader();
        for (Event event : events) {
            TaskRecord task = null;
            try {
                task = TaskPersistLayer.getTaskFromEventId((String)event.getEventId().toXMLString());
            }
            catch (TaskPersistLayerException e1) {
                e1.printStackTrace();
            }
            SDSInstance otherInstance = null;
            if (task != null) {
                otherInstance = task.getSdsInstanceId() == null ? sdsInstanceManager.getThisInstance() : sdsInstanceManager.getSDSInstance(task.getSdsInstanceId());
                if (otherInstance == null) {
                    eventsContext.getEventList("ORPHANED_EVENTS").add(event);
                    continue;
                }
                EventManagementServiceClientPort crnPort = null;
                try {
                    Dispatcher_Type dispatcher = otherInstance.getDispatcherType(header);
                    crnPort = Client.instance().getEventmanagementServiceClient(new JobBiBusHeaders(header));
                    crnPort.setEndpoint(new URL(otherInstance.getUrl()));
                    String soapactionCurrentVersion = SoapActionHelper.getCurrentVersion();
                    crnPort.setNextSoapAction("http://www.ibm.com/xmlns/prod/cognos/monitorService/" + soapactionCurrentVersion + "/.server");
                    ConversationContext conversationContext = new ConversationContext();
                    conversationContext.setNodeID(dispatcher.getDispatcherID().getValue().get_value());
                    header.getTracking().setConversationContext(conversationContext);
                    crnPort.cancelEvent(event.getEventId().toXMLString());
                    continue;
                }
                catch (EMFSecurityException e) {
                    this.handleError("invoke(): Error forwarding an UpdateEventStatus request: " + e.getMessage(), I18NCode.EVENT_UPDATE_ERROR, null, eventsContext);
                    continue;
                }
                catch (SDKClientException e) {
                    this.handleError("invoke(): Error forwarding an UpdateEventStatus request: " + e.getMessage(), I18NCode.EVENT_UPDATE_ERROR, (LocalizableException)((Object)e), eventsContext);
                    continue;
                }
                catch (MalformedURLException e) {
                    this.handleError("invoke(): MalformedURLException", I18NCode.EVENT_UPDATE_ERROR, null, eventsContext);
                    e.printStackTrace();
                    continue;
                }
                finally {
                    if (crnPort != null) {
                        crnPort.close();
                    }
                    continue;
                }
            }
            this.handleError("invoke(): No current running event found with ID [" + event.getEventId().toXMLString() + "].", I18NCode.EVENT_RETRIEVE_ERROR, null, eventsContext);
            eventsContext.addUpdateEventFault(new ProcessHandlerException(I18NCode.EVENT_RETRIEVE_ERROR));
        }
    }

    private void handleError(String debugMessage, I18NCode errorCode, LocalizableException nested, EventsContext eventsContext) {
        SDSLogger logger = SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME);
        if (nested != null) {
            logger.log(SDSLevel.WARN, nested);
            eventsContext.addUpdateEventFault(new ProcessHandlerException(errorCode, nested));
        } else {
            eventsContext.addUpdateEventFault(new ProcessHandlerException(errorCode));
        }
        logger.debug((Object)this, debugMessage);
    }
}

