/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.event.persist;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.jdbc.util.SqlResourceCloser;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.serverinst.SDSInstance;
import com.cognos.jsmcommon.serverinst.SDSInstanceManager;
import com.cognos.sds.event.EventIdUtil;
import com.cognos.sds.event.IEventId;
import com.cognos.sds.event.persist.EventIdStatusTableException;
import com.cognos.sds.event.persist.EventStatusPersister;
import com.cognos.sds.event.persist.IEventStatusPersister;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;

public class EventIdStatusTable {
    private static final String m_JDBC_TABLE = "NC_EVENTSTATUS";
    private static final String m_F_EVENT_ID = "PK_EVENT_ID";
    private static final String m_F_EVENT_STATUS = "EVENT_STATUS";
    private static final String m_F_SDS_INSTANCE_ID = "SDS_INSTANCE_ID";
    private static final String m_INSERT_SQL = new StringBuffer("").append("INSERT INTO ").append("NC_EVENTSTATUS").append(" (").append("PK_EVENT_ID").append(", ").append("EVENT_STATUS").append(", ").append("SDS_INSTANCE_ID").append(")  VALUES (?,?,?)").toString();
    private static final String m_SELECT_STATUS = new StringBuffer("").append("SELECT ").append("EVENT_STATUS").append(" FROM ").append("NC_EVENTSTATUS").append(" WHERE ").append("PK_EVENT_ID").append(" = ?").toString();
    private static final String m_SELECT_ENTRY_BY_ID = new StringBuffer("").append("SELECT ").append("EVENT_STATUS").append(", ").append("SDS_INSTANCE_ID").append(" FROM ").append("NC_EVENTSTATUS").append(" WHERE ").append("PK_EVENT_ID").append(" = ?").toString();
    private static final String m_SELECT_EVENTIDS_BY_STATUS = new StringBuffer("").append("SELECT ").append("PK_EVENT_ID").append(" FROM ").append("NC_EVENTSTATUS").append(" WHERE ").append("EVENT_STATUS").append(" = ?").toString();
    private static final String m_SELECT_EVENTIDS_BY_SDS_INSTANCE = new StringBuffer("").append("SELECT ").append("PK_EVENT_ID").append(" FROM ").append("NC_EVENTSTATUS").append(" WHERE ").append("SDS_INSTANCE_ID").append(" = ?").toString();
    private static final String m_DELETE_EVENTID = new StringBuffer("").append("DELETE FROM ").append("NC_EVENTSTATUS").append(" WHERE ").append("PK_EVENT_ID").append(" = ?").toString();
    private static final String m_DELETE_STATUS = new StringBuffer("").append("DELETE FROM ").append("NC_EVENTSTATUS").append(" WHERE ").append("EVENT_STATUS").append(" = ?").toString();
    private static final String m_UPDATE_STATUS = new StringBuffer("").append("UPDATE ").append("NC_EVENTSTATUS").append(" SET ").append("EVENT_STATUS").append(" = ?").append(" WHERE ").append("PK_EVENT_ID").append(" = ?").toString();
    private static final String m_UPDATE_SDSINSTANCE = new StringBuffer("").append("UPDATE ").append("NC_EVENTSTATUS").append(" SET ").append("SDS_INSTANCE_ID").append(" = ?").append(" WHERE ").append("PK_EVENT_ID").append(" = ?").toString();
    private static EventIdStatusTable instance = new EventIdStatusTable();

    public static EventIdStatusTable getInstance() {
        return instance;
    }

    private EventIdStatusTable() {
    }

    public void insertRow(IEventId event_id, IEventStatusPersister event_status) throws EventIdStatusTableException {
        JDBCConnection conn = null;
        PreparedStatement ps = null;
        try {
            conn = NCConnection.instance().getConnectionFactory().createConnection();
            ps = conn.prepareStatement(m_INSERT_SQL);
            EventIdUtil.setIntoStatement(event_id, ps, 1);
            ps.setInt(2, event_status.getInteger());
            EventStatus status = event_status.getEventStatus();
            if (status != null && status.equals((Object)EventStatus.EXECUTING)) {
                SDSInstanceManager instanceManager = SDSInstanceManager.getInstance();
                ps.setString(3, instanceManager.getThisInstance().getGuid());
            } else {
                ps.setNull(3, 12);
            }
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.MSG_ERROR_INSERT_EVENT_STATUS_TABLE, (Object[])new String[]{e.getMessage() + "", this.getClass().toString()});
                throw new EventIdStatusTableException(I18NCode.EVENT_PERSIST_ERROR);
            }
            catch (Throwable throwable) {
                SqlResourceCloser.closeResources(null, ps);
                if (conn != null) {
                    try {
                        NCConnection.instance().getConnectionFactory().releaseConnection(conn);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        SqlResourceCloser.closeResources(null, (Statement)ps);
        if (conn != null) {
            try {
                NCConnection.instance().getConnectionFactory().releaseConnection(conn);
            }
            catch (SQLException status) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void selectStatus(IEventId event_id, IEventStatusPersister event_status) throws EventIdStatusTableException {
        JDBCConnection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = NCConnection.instance().getConnectionFactory().createConnection();
            ps = conn.prepareStatement(m_SELECT_STATUS);
            EventIdUtil.setIntoStatement(event_id, ps, 1);
            rs = ps.executeQuery();
            if (rs.next()) {
                int event_status_int = rs.getInt(1);
                event_status.valueOf(event_status_int);
            }
            this.closeResources(ps, rs);
            if (conn == null) return;
        }
        catch (SQLException e) {
            try {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.MSG_ERROR_INSERT_EVENT_STATUS_TABLE, (Object[])new String[]{e.getMessage() + ""});
                throw new EventIdStatusTableException(I18NCode.MSG_ERROR_RETRIEVE_EVENT_STATUS_TABLE, new String[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                this.closeResources(ps, rs);
                if (conn == null) throw throwable;
                try {
                    NCConnection.instance().getConnectionFactory().releaseConnection(conn);
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            NCConnection.instance().getConnectionFactory().releaseConnection(conn);
            return;
        }
        catch (SQLException event_status_int) {
            return;
        }
    }

    public Iterator selectEventIds(IEventStatusPersister status) throws EventIdStatusTableException {
        JDBCConnection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<IEventId> array = new ArrayList<IEventId>();
        try {
            conn = NCConnection.instance().getConnectionFactory().createConnection();
            ps = conn.prepareStatement(m_SELECT_EVENTIDS_BY_STATUS);
            ps.setInt(1, status.getInteger());
            rs = ps.executeQuery();
            while (rs.next()) {
                IEventId event_id = EventIdUtil.readFromResultSet(rs, 1);
                array.add(event_id);
            }
        }
        catch (SQLException e) {
            try {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.MSG_ERROR_INSERT_EVENT_STATUS_TABLE, (Object[])new String[]{e.getMessage() + "", this.getClass().toString()});
                throw new EventIdStatusTableException(I18NCode.MSG_ERROR_RETRIEVE_EVENT_STATUS_TABLE, new String[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                SqlResourceCloser.closeResources(rs, ps);
                if (conn != null) {
                    try {
                        NCConnection.instance().getConnectionFactory().releaseConnection(conn);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        SqlResourceCloser.closeResources((ResultSet)rs, (Statement)ps);
        if (conn != null) {
            try {
                NCConnection.instance().getConnectionFactory().releaseConnection(conn);
            }
            catch (SQLException event_id) {}
        }
        return array.iterator();
    }

    public Iterator selectEventIds(SDSInstance sdsInstance) throws EventIdStatusTableException {
        JDBCConnection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<IEventId> array = new ArrayList<IEventId>();
        try {
            conn = NCConnection.instance().getConnectionFactory().createConnection();
            ps = conn.prepareStatement(m_SELECT_EVENTIDS_BY_SDS_INSTANCE);
            ps.setString(1, sdsInstance.getGuid());
            rs = ps.executeQuery();
            while (rs.next()) {
                IEventId event_id = EventIdUtil.readFromResultSet(rs, 1);
                array.add(event_id);
            }
        }
        catch (SQLException e) {
            try {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.MSG_ERROR_INSERT_EVENT_STATUS_TABLE, (Object[])new String[]{e.getMessage() + ""});
                throw new EventIdStatusTableException(I18NCode.MSG_ERROR_RETRIEVE_EVENT_STATUS_TABLE, new String[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                SqlResourceCloser.closeResources(rs, ps);
                if (conn != null) {
                    try {
                        NCConnection.instance().getConnectionFactory().releaseConnection(conn);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        SqlResourceCloser.closeResources((ResultSet)rs, (Statement)ps);
        if (conn != null) {
            try {
                NCConnection.instance().getConnectionFactory().releaseConnection(conn);
            }
            catch (SQLException event_id) {}
        }
        return array.iterator();
    }

    public void deleteStatus(IEventStatusPersister status) throws EventIdStatusTableException {
        JDBCConnection conn = null;
        PreparedStatement ps = null;
        try {
            conn = NCConnection.instance().getConnectionFactory().createConnection();
            ps = conn.prepareStatement(m_DELETE_STATUS);
            ps.setInt(1, status.getInteger());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.MSG_ERROR_INSERT_EVENT_STATUS_TABLE, (Object[])new String[]{e.getMessage() + ""});
                throw new EventIdStatusTableException(I18NCode.MSG_ERROR_DELETE_EVENT_STATUS_TABLE, new String[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                SqlResourceCloser.closeResources(null, ps);
                if (conn != null) {
                    try {
                        NCConnection.instance().getConnectionFactory().releaseConnection(conn);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        SqlResourceCloser.closeResources(null, (Statement)ps);
        if (conn != null) {
            try {
                NCConnection.instance().getConnectionFactory().releaseConnection(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    public void deleteEventID(IEventId event_id) throws EventIdStatusTableException {
        JDBCConnection conn = null;
        PreparedStatement ps = null;
        try {
            conn = NCConnection.instance().getConnectionFactory().createConnection();
            ps = conn.prepareStatement(m_DELETE_EVENTID);
            EventIdUtil.setIntoStatement(event_id, ps, 1);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.MSG_ERROR_INSERT_EVENT_STATUS_TABLE, (Object[])new String[]{e.getMessage() + ""});
                throw new EventIdStatusTableException(I18NCode.MSG_ERROR_DELETE_EVENT_STATUS_TABLE, new String[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                SqlResourceCloser.closeResources(null, ps);
                if (conn != null) {
                    try {
                        NCConnection.instance().getConnectionFactory().releaseConnection(conn);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        SqlResourceCloser.closeResources(null, (Statement)ps);
        if (conn != null) {
            try {
                NCConnection.instance().getConnectionFactory().releaseConnection(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    public void updateStatus(IEventId event_id, IEventStatusPersister statusPersister) throws EventIdStatusTableException {
        JDBCConnection conn = null;
        PreparedStatement ps = null;
        try {
            conn = NCConnection.instance().getConnectionFactory().createConnection();
            ps = conn.prepareStatement(m_UPDATE_STATUS);
            ps.setInt(1, statusPersister.getInteger());
            EventIdUtil.setIntoStatement(event_id, ps, 2);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.MSG_ERROR_INSERT_EVENT_STATUS_TABLE, (Object[])new String[]{e.getMessage() + ""});
                throw new EventIdStatusTableException(I18NCode.MSG_ERROR_UPDATE_EVENT_STATUS_TABLE, new String[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                SqlResourceCloser.closeResources(null, ps);
                if (conn != null) {
                    try {
                        NCConnection.instance().getConnectionFactory().releaseConnection(conn);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        SqlResourceCloser.closeResources(null, (Statement)ps);
        if (conn != null) {
            try {
                NCConnection.instance().getConnectionFactory().releaseConnection(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    public void updateSdsInstance(Connection conn, IEventId event_id) throws EventIdStatusTableException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(m_UPDATE_SDSINSTANCE);
            SDSInstanceManager instanceManager = SDSInstanceManager.getInstance();
            ps.setString(1, instanceManager.getThisInstance().getGuid());
            EventIdUtil.setIntoStatement(event_id, ps, 2);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.MSG_ERROR_INSERT_EVENT_STATUS_TABLE, (Object[])new String[]{e.getMessage() + ""});
            throw new EventIdStatusTableException(I18NCode.MSG_ERROR_UPDATE_EVENT_STATUS_TABLE, new String[]{e.getMessage()});
        }
        finally {
            SqlResourceCloser.closeResources(null, (Statement)ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StatusTableEntry getStatusTableEntry(IEventId eventId) {
        StatusTableEntry result = null;
        JDBCConnection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        conn = NCConnection.instance().getConnectionFactory().createConnection();
        ps = conn.prepareStatement(m_SELECT_ENTRY_BY_ID);
        EventIdUtil.setIntoStatement(eventId, ps, 1);
        rs = ps.executeQuery();
        if (rs.next()) {
            int eventStatusInt = rs.getInt(1);
            String sdsInstanceGuid = rs.getString(2);
            EventStatusPersister persister = new EventStatusPersister();
            persister.valueOf(eventStatusInt);
            EventStatus status = persister.getEventStatus();
            result = new StatusTableEntry(eventId, status, sdsInstanceGuid);
        }
        this.closeResources(ps, rs);
        if (conn == null) return result;
        try {
            NCConnection.instance().getConnectionFactory().releaseConnection(conn);
            return result;
        }
        catch (SQLException eventStatusInt) {}
        return result;
        catch (SQLException e) {
            try {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.MSG_ERROR_INSERT_EVENT_STATUS_TABLE, (Object[])new String[]{e.getMessage() + ""});
                this.closeResources(ps, rs);
                if (conn == null) return result;
            }
            catch (Throwable throwable) {
                this.closeResources(ps, rs);
                if (conn == null) throw throwable;
                try {
                    NCConnection.instance().getConnectionFactory().releaseConnection(conn);
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                NCConnection.instance().getConnectionFactory().releaseConnection(conn);
                return result;
            }
            catch (SQLException sQLException) {}
            return result;
        }
    }

    private void closeResources(Statement statement, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public class StatusTableEntry {
        IEventId m_eventId;
        EventStatus m_status;
        String m_sdsInstanceGuid;

        public StatusTableEntry(IEventId eventId, EventStatus status, String sdsInstanceGuid) {
            this.m_eventId = eventId;
            this.m_status = status;
            this.m_sdsInstanceGuid = sdsInstanceGuid;
        }

        public IEventId getEventId() {
            return this.m_eventId;
        }

        public EventStatus getStatus() {
            return this.m_status;
        }

        public String getSDSInstanceGuid() {
            return this.m_sdsInstanceGuid;
        }
    }
}

