/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.schedule;

import com.cognos.developer.schemas.bibus._3.Schedule;
import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.sds.adapter.ScheduleAdapter;
import com.cognos.sds.handler.IChainHandler;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BatchScheduleHandler
implements IChainHandler {
    private List m_handlers;
    private boolean m_logOnly = false;

    public BatchScheduleHandler() {
        this(false);
    }

    public BatchScheduleHandler(boolean logOnly) {
        this.m_logOnly = logOnly;
        this.m_handlers = new ArrayList();
    }

    @Override
    public void add(ProcessHandler handler) {
        this.m_handlers.add(handler);
    }

    @Override
    public void set(List handlers) {
        this.m_handlers = handlers;
    }

    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        Schedule[] schedules = context.getSchedules();
        ArrayList<Schedule> new_schedules = new ArrayList<Schedule>();
        for (int i = 0; i < schedules.length; ++i) {
            try {
                ScheduleAdapter adapter = new ScheduleAdapter(schedules[i]);
                context.setScheduleAdapter(adapter);
                Iterator handlers = this.m_handlers.iterator();
                while (handlers.hasNext()) {
                    ((ProcessHandler)handlers.next()).invoke(context);
                }
                new_schedules.add(adapter.getSchedule());
                continue;
            }
            catch (ProcessHandlerException e) {
                if (this.m_logOnly) {
                    SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug((Throwable)((Object)e));
                    continue;
                }
                throw e;
            }
        }
        context.setSchedules(new_schedules.toArray(new Schedule[new_schedules.size()]));
    }
}

