/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.schedule.validation;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.sds.adapter.ScheduleAdapter;
import com.cognos.sds.schedule.validation.ScheduleValidationException;
import java.util.ArrayList;
import java.util.Date;

public class BaseScheduleValidator {
    private ArrayList<String> errorMessages = new ArrayList();
    private boolean isScheduleValid = true;

    public final void validateSchedule(ScheduleAdapter scheduleAdaptor) throws ScheduleValidationException {
        this.validate(scheduleAdaptor);
        if (!this.isScheduleValid) {
            String errorMessage = this.generateErrorMessage();
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.GEN_THROWABLE_ERROR, (Object[])new String[]{" Schedule Validation Failed : " + errorMessage});
            throw new ScheduleValidationException(errorMessage);
        }
    }

    private String generateErrorMessage() {
        StringBuffer sb = new StringBuffer();
        if (this.errorMessages != null) {
            for (String message : this.errorMessages) {
                if (message == null || message.trim().equals("")) continue;
                sb.append(message);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    protected void validate(ScheduleAdapter scheduleAdapter) throws ScheduleValidationException {
        SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug(" validate() method called for class: BaseScheduleValidator");
        Date startDate = scheduleAdapter.getStartDate();
        Date endDate = scheduleAdapter.getEndDate();
        this.isStartDateSet(startDate);
        this.isStartDateBeforeEndDate(startDate, endDate);
    }

    protected final void validationFailed(String validationFailErrorMessage) {
        this.isScheduleValid = false;
        this.errorMessages.add(validationFailErrorMessage);
    }

    private boolean isStartDateSet(Date startDate) {
        if (startDate == null) {
            this.validationFailed("Start date is null");
            return false;
        }
        return true;
    }

    private boolean isStartDateBeforeEndDate(Date startDate, Date endDate) {
        if (startDate != null && endDate != null && startDate.compareTo(endDate) >= 0) {
            this.validationFailed("Schedule start date is after the schedule end date");
            return false;
        }
        return true;
    }
}

