/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.schedule.validation;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BooleanProp;
import com.cognos.developer.schemas.bibus._3.Schedule;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.UpdateOptions;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.monitor.MonitorCategory;
import com.cognos.sds.handler.ProcessContext;

public class InvalidScheduleResolutionUtil {
    public void action(ProcessContext context) {
        ContentManagerServiceClientPort port = null;
        JobBiBusHeaders headers = new JobBiBusHeaders();
        port = Client.instance().getContentManagerServiceClient(headers);
        port.setLogCategory(MonitorCategory.RUNTIME);
        try {
            Schedule invalidSchedule = context.getScheduleAdapter().getSchedule();
            String parentsearchpath = invalidSchedule.getParent().getValue()[0].getSearchPath().getValue();
            if (parentsearchpath != null && parentsearchpath.length() > 0) {
                StringProp str = new StringProp();
                str.setValue(parentsearchpath + "/schedule");
                invalidSchedule.setSearchPath(str);
                BooleanProp disabledProp = new BooleanProp();
                disabledProp.setValue(true);
                invalidSchedule.setDisabled(disabledProp);
                UpdateOptions options = new UpdateOptions();
                options.setIgnoreInvalidObjectReference(true);
                options.setUpdateTenantIDRecursive(true);
                port.signNextRequest("JSM");
                port.update(new BaseClass[]{invalidSchedule}, options);
            }
        }
        catch (LocalizableException loc) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, loc);
        }
        catch (EMFSecurityException e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (Throwable)e);
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (Throwable)e);
        }
    }

    public static boolean isScheduleValidationOn() {
        boolean enabled = false;
        try {
            String str = CRNProperties.getInstance().getProperty("emf.schedule.validation.enabled");
            if (str != null && str.trim().length() > 0) {
                enabled = Boolean.valueOf(str);
            }
        }
        catch (PropertiesException ex) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, (LocalizableException)((Object)ex));
        }
        catch (Throwable t) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, t);
        }
        return enabled;
    }
}

