/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.schedule.validation;

import com.cognos.developer.schemas.bibus._3.Schedule;
import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import com.cognos.sds.schedule.validation.BaseScheduleValidator;
import com.cognos.sds.schedule.validation.InvalidScheduleResolutionUtil;
import com.cognos.sds.schedule.validation.ScheduleValidationException;
import com.cognos.sds.schedule.validation.ScheduleValidatorFactory;

public class ScheduleValidationHandler
implements ProcessHandler {
    private static ScheduleValidationHandler instance = new ScheduleValidationHandler();

    private ScheduleValidationHandler() {
    }

    public static ScheduleValidationHandler getInstance() {
        return instance;
    }

    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        try {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug("ScheduleValidationHandler -> invoke() called");
            Schedule schedule = context.getScheduleAdapter().getSchedule();
            String scheduleType = schedule.getType().getValue();
            BaseScheduleValidator scheduleValidator = ScheduleValidatorFactory.getInstance().getValidator(scheduleType);
            scheduleValidator.validateSchedule(context.getScheduleAdapter());
        }
        catch (ScheduleValidationException ex) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.GEN_THROWABLE_ERROR, (Object[])new String[]{" Schedule Validation Failed : " + ex.getMessage()});
            InvalidScheduleResolutionUtil isru = new InvalidScheduleResolutionUtil();
            isru.action(context);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.GEN_THROWABLE_ERROR, (Object[])new String[]{" The Schedule has been disabled. "});
        }
        catch (Exception ex) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.GEN_THROWABLE_ERROR, (Object[])new String[]{" Error during Schedule Validation : " + ex.getMessage()});
        }
    }
}

