/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.schedule.validation;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.sds.schedule.validation.BaseScheduleValidator;
import com.cognos.sds.schedule.validation.DailyScheduleValidator;
import com.cognos.sds.schedule.validation.DailyWithIntradayRecurrenceScheduleValidator;
import com.cognos.sds.schedule.validation.MonthlyAbsoluteScheduleValidator;
import com.cognos.sds.schedule.validation.MonthlyAbsoluteWithIntradayRecurrenceScheduleValidator;
import com.cognos.sds.schedule.validation.MonthlyRelativeScheduleValidator;
import com.cognos.sds.schedule.validation.MonthlyRelativeWithIntradayRecurrenceScheduleValidator;
import com.cognos.sds.schedule.validation.RunOnceScheduleValidator;
import com.cognos.sds.schedule.validation.TriggerScheduleValidator;
import com.cognos.sds.schedule.validation.WeeklyScheduleValidator;
import com.cognos.sds.schedule.validation.WeeklyWithIntradayRecurrenceScheduleValidator;
import com.cognos.sds.schedule.validation.YearlyAbsoluteScheduleValidator;
import com.cognos.sds.schedule.validation.YearlyAbsoluteWithIntradayRecurrenceScheduleValidator;
import com.cognos.sds.schedule.validation.YearlyRelativeScheduleValidator;
import com.cognos.sds.schedule.validation.YearlyRelativeWithIntradayRecurrenceScheduleValidator;
import java.util.HashMap;

public class ScheduleValidatorFactory {
    private static ScheduleValidatorFactory scheduleValidatorFactory = null;
    private HashMap<String, Class> scheduleValidators = new HashMap();

    private ScheduleValidatorFactory() {
        this.defineValidatorClassMappings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScheduleValidatorFactory getInstance() {
        Class<ScheduleValidatorFactory> clazz = ScheduleValidatorFactory.class;
        synchronized (ScheduleValidatorFactory.class) {
            if (scheduleValidatorFactory == null) {
                scheduleValidatorFactory = new ScheduleValidatorFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return scheduleValidatorFactory;
        }
    }

    public synchronized BaseScheduleValidator getValidator(String scheduleType) {
        BaseScheduleValidator scheduleValidator = null;
        try {
            Class validatorClass = this.scheduleValidators.get(scheduleType);
            scheduleValidator = validatorClass != null ? (BaseScheduleValidator)validatorClass.newInstance() : new BaseScheduleValidator();
        }
        catch (Exception ex) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.GEN_THROWABLE_ERROR, (Object[])new String[]{ex.getMessage()});
        }
        return scheduleValidator;
    }

    private synchronized void defineValidatorClassMappings() {
        this.scheduleValidators.put("once", RunOnceScheduleValidator.class);
        this.scheduleValidators.put("trigger", TriggerScheduleValidator.class);
        this.scheduleValidators.put("subscription", BaseScheduleValidator.class);
        this.scheduleValidators.put("daily", DailyScheduleValidator.class);
        this.scheduleValidators.put("dailyWithIntradayRecurrence", DailyWithIntradayRecurrenceScheduleValidator.class);
        this.scheduleValidators.put("weekly", WeeklyScheduleValidator.class);
        this.scheduleValidators.put("weeklyWithIntradayRecurrence", WeeklyWithIntradayRecurrenceScheduleValidator.class);
        this.scheduleValidators.put("monthlyAbsolute", MonthlyAbsoluteScheduleValidator.class);
        this.scheduleValidators.put("monthlyRelative", MonthlyRelativeScheduleValidator.class);
        this.scheduleValidators.put("monthlyAbsoluteWithIntradayRecurrence", MonthlyAbsoluteWithIntradayRecurrenceScheduleValidator.class);
        this.scheduleValidators.put("monthlyRelativeWithIntradayRecurrence", MonthlyRelativeWithIntradayRecurrenceScheduleValidator.class);
        this.scheduleValidators.put("yearlyAbsolute", YearlyAbsoluteScheduleValidator.class);
        this.scheduleValidators.put("yearlyRelative", YearlyRelativeScheduleValidator.class);
        this.scheduleValidators.put("yearlyAbsoluteWithIntradayRecurrence", YearlyAbsoluteWithIntradayRecurrenceScheduleValidator.class);
        this.scheduleValidators.put("yearlyRelativeWithIntradayRecurrence", YearlyRelativeWithIntradayRecurrenceScheduleValidator.class);
    }
}

