/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.security;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.jsmcommon.api.SDSServiceException;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.ISDSLogger;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.tse.BiBusRunSpec;
import com.cognos.jsmcommon.tse.NCTaskQueueTable;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.EventsContext;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandlerException;
import com.cognos.sds.security.EventSecurityHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CurrentEventSecurityHandler
extends EventSecurityHandler {
    public CurrentEventSecurityHandler() {
    }

    public CurrentEventSecurityHandler(ISDSLogger logger) {
        super(logger);
    }

    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        EventsContext eventsContext = context.getEventsContext();
        boolean mustCheckPermissions = this.isObjectPermissionsRequired();
        if (context.hasCanUseMonitorActivyToolCapability() && !mustCheckPermissions) {
            return;
        }
        List cancels = eventsContext.getEventList("LOCAL_CANCEL");
        List holds = eventsContext.getEventList("LOCAL_HOLD");
        List releases = eventsContext.getEventList("LOCAL_RELASE");
        List nonLocals = eventsContext.getEventList("NON_LOCAL_EVENTS");
        cancels = this.validateEvents(cancels, context, eventsContext, mustCheckPermissions);
        holds = this.validateEvents(holds, context, eventsContext, mustCheckPermissions);
        releases = this.validateEvents(releases, context, eventsContext, mustCheckPermissions);
        nonLocals = this.validateEvents(nonLocals, context, eventsContext, mustCheckPermissions);
        eventsContext.setEventList("LOCAL_CANCEL", cancels);
        eventsContext.setEventList("LOCAL_HOLD", holds);
        eventsContext.setEventList("LOCAL_RELASE", releases);
        eventsContext.setEventList("NON_LOCAL_EVENTS", nonLocals);
    }

    private List validateEvents(List events, ProcessContext context, EventsContext eventsContext, boolean mustCheckPermissions) {
        List result = new ArrayList();
        if (events != null && events.size() > 0) {
            Map eventMap = this.buildListMap(events);
            for (Event event : events) {
                try {
                    TaskID taskID = TaskID.fromEventId((String)event.getEventId().toString());
                    TaskRecord task = NCTaskQueueTable.getInstance().find(taskID, true);
                    if (null == task) {
                        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("CurrentEventSecurityHandler.validateEvents(): No StepObject found for event with ID [" + event.getEventId().toXMLString() + "].");
                        throw new ProcessHandlerException(I18NCode.EVENT_RETRIEVE_ERROR);
                    }
                    BiBusHeader header = ((BiBusRunSpec)task.getRunSpec()).header;
                    String credential = header.getCAM().getCAMCredentialPath();
                    CAMPassport passport = header.getCAM().getCAMPassport();
                    if (!mustCheckPermissions) {
                        if (credential != null) {
                            this.validateCredential(context, credential);
                            continue;
                        }
                        if (passport != null && passport.getId() != null) {
                            this.validateHeaderPassport(context, header);
                            continue;
                        }
                        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("CurrentEventSecurityHandler.validateEvents(): No credential or passport found for user, unable to authenticate request.");
                        throw new ProcessHandlerException(I18NCode.SEC_NO_PRIVELEDGES);
                    }
                    try {
                        if (credential != null) {
                            this.validateCredential(context, credential);
                            continue;
                        }
                        if (passport != null && passport.getId() != null) {
                            this.validateHeaderPassport(context, header);
                            continue;
                        }
                        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("CurrentEventSecurityHandler.validateEvents(): No credential or passport found for user, unable to authenticate request.");
                        throw new ProcessHandlerException(I18NCode.SEC_NO_PRIVELEDGES);
                    }
                    catch (ProcessHandlerException e) {
                        String searchPath = "storeID('" + task.getTaskStoreId() + "')";
                        this.validateObjectPermissions(context.getBiBusHeader(), searchPath);
                    }
                }
                catch (TaskPersistLayerException e) {
                    this.removeEvent(eventMap, event);
                    eventsContext.addUpdateEventFault(new SDSServiceException(I18NCode.GUID_ERROR_RETRIEVE_LINK, (Object[])new String[]{event.getEventId().toXMLString()}, (Throwable)e));
                }
                catch (ProcessHandlerException e) {
                    this.removeEvent(eventMap, event);
                    eventsContext.addUpdateEventFault(e);
                }
            }
            result = this.getEvents(eventMap);
        }
        return result;
    }
}

