/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.security;

import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.ISDSLogger;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.sds.event.handlers.EventHandlerBase;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandlerException;
import com.cognos.sds.security.UserAccountSecurityHandler;

public abstract class EventSecurityHandler
extends EventHandlerBase {
    ISDSLogger m_logger;

    public EventSecurityHandler() {
        this.m_logger = SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME);
    }

    public EventSecurityHandler(ISDSLogger logger) {
        this.m_logger = logger;
    }

    @Override
    public abstract void invoke(ProcessContext var1) throws ProcessHandlerException;

    protected void validateCredential(ProcessContext context, String credentialPath) throws ProcessHandlerException {
        String id;
        Account account = context.getUserAccount();
        String string = id = account.getSearchPath() != null ? account.getSearchPath().getValue() : null;
        if (id == null) {
            this.m_logger.debug("EventSecurityHandler.validateCredential(): No CAMID found for user, unable to authenticate request.");
            throw new ProcessHandlerException(I18NCode.SEC_NO_ACCOUNT_INFO);
        }
        if (credentialPath == null || !credentialPath.startsWith(id)) {
            if (credentialPath == null) {
                this.m_logger.debug("EventSecurityHandler.validateCredential(): No credential for user, unable to authenticate request.");
            } else {
                this.m_logger.debug("EventSecurityHandler.validateCredential(): Current user is not the owner of the credential.  User request has failed authentication.");
            }
            throw new ProcessHandlerException(I18NCode.SEC_NO_PRIVELEDGES);
        }
    }

    protected void validateHeaderPassport(ProcessContext context, BiBusHeader header) throws ProcessHandlerException {
        ProcessContext runningContext = new ProcessContext();
        runningContext.setBiBusHeader(header);
        UserAccountSecurityHandler handler = new UserAccountSecurityHandler();
        handler.invoke(runningContext);
        Account runningAccount = runningContext.getUserAccount();
        Account requestAccount = context.getUserAccount();
        if (requestAccount.getSearchPath() != null && runningAccount.getSearchPath() != null) {
            if (!requestAccount.getSearchPath().getValue().equals(runningAccount.getSearchPath().getValue())) {
                this.m_logger.debug("EventSecurityHandler.validateHeaderPassport(): Current user is not running the StepObject, unable to authenticate request.");
                throw new ProcessHandlerException(I18NCode.SEC_NO_PRIVELEDGES);
            }
        } else {
            if (requestAccount.getSearchPath() != null) {
                this.m_logger.debug("EventSecurityHandler.validateHeaderPassport(): No account information found for the current user, unable to authenticate request.");
            } else {
                this.m_logger.debug("EventSecurityHandler.validateHeaderPassport(): No account information found for the user running the StepObject, unable to authenticate request.");
            }
            throw new ProcessHandlerException(I18NCode.SEC_NO_ACCOUNT_INFO);
        }
    }

    public boolean isObjectPermissionsRequired() {
        boolean permissionsCheck = false;
        try {
            String value = CRNProperties.getInstance().getProperty("ems.action.requires.permissions.check");
            if (value != null && Boolean.valueOf(value).booleanValue()) {
                permissionsCheck = true;
            }
        }
        catch (PropertiesException e1) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug("PropertiesException retrieving property [ems.action.requires.permissions.check]: " + e1.getLocalizedMessage());
        }
        return permissionsCheck;
    }

    public void validateObjectPermissions(BiBusHeader header, String searchPath) throws ProcessHandlerException {
        JobBiBusHeaders headers = new JobBiBusHeaders(header);
        ContentManagerServiceClientPort cmPort = Client.instance().getContentManagerServiceClient(headers);
        QueryRequest permissionsRequest = new QueryRequest();
        permissionsRequest.setSearch(searchPath);
        permissionsRequest.setProperties(new PropEnum[]{PropEnum.defaultName, PropEnum.searchPath, PropEnum.storeID, PropEnum.permissions});
        permissionsRequest.setOptions(null);
        permissionsRequest.setSortBy(null);
        boolean hasPermissions = false;
        BaseClass baseClass = null;
        try {
            baseClass = cmPort.query(permissionsRequest);
        }
        catch (SDKClientException e) {
            this.m_logger.debug("EventSecurityHandler.validateObjectPermissions() SDKClientException retrieving object permissions: " + e.getLocalizedMessage());
            throw new ProcessHandlerException(I18NCode.SEC_NO_PRIVELEDGES);
        }
        catch (EMFSecurityException e) {
            this.m_logger.debug("EventSecurityHandler.validateObjectPermissions() EMFSecurityException object permissions: " + e.getLocalizedMessage());
            throw new ProcessHandlerException(I18NCode.SEC_NO_PRIVELEDGES);
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        if (baseClass != null) {
            String[] permissions = new String[]{"execute", "traverse"};
            hasPermissions = AuthenticatorFactory.getInstance().hasPermissions(baseClass, permissions);
        }
        if (!hasPermissions) {
            this.m_logger.debug("EventSecurityHandler.validateObjectPermissions(): Current user does not have object permissions - validation failed");
            throw new ProcessHandlerException(I18NCode.SEC_NO_PRIVELEDGES);
        }
    }
}

