/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.security;

import com.cognos.developer.schemas.bibus._3.Schedule;
import com.cognos.sds.adapter.ScheduleAdapter;
import com.cognos.sds.core.task.ScheduleCredentialHandler;
import com.cognos.sds.event.EventsContext;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandlerException;
import com.cognos.sds.security.EventSecurityHandler;
import java.util.Map;

public class FutureEventSecurityHandler
extends EventSecurityHandler {
    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        EventsContext eventsContext = context.getEventsContext();
        boolean mustCheckPermissions = this.isObjectPermissionsRequired();
        if (context.hasCanUseMonitorActivyToolCapability() && !mustCheckPermissions) {
            return;
        }
        Schedule[] schedules = context.getSchedules();
        Map eventMap = this.buildListMap(eventsContext.getEventList("FUTURE_EVENTS"));
        for (int i = 0; schedules != null && i < schedules.length; ++i) {
            try {
                ScheduleAdapter adapter = new ScheduleAdapter(schedules[i]);
                context.setScheduleAdapter(adapter);
                ScheduleCredentialHandler.getInstance().invoke(context);
                String credential = adapter.getCredentialSearchPath();
                if (!mustCheckPermissions) {
                    this.validateCredential(context, credential);
                    continue;
                }
                try {
                    this.validateCredential(context, credential);
                }
                catch (ProcessHandlerException e) {
                    String searchPath = "storeID('" + adapter.getParentStoreID() + "')";
                    this.validateObjectPermissions(context.getBiBusHeader(), searchPath);
                }
                continue;
            }
            catch (ProcessHandlerException e) {
                this.removeEvents(eventMap, schedules[i].getTaskID().getValue());
                eventsContext.addUpdateEventFault(e);
            }
        }
        eventsContext.setEventList("FUTURE_EVENTS", this.getEvents(eventMap));
    }
}

