/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.security;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.api.SDSServiceException;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;

public class MonitorActivityToolCapabilityHandler
implements ProcessHandler {
    private boolean m_faultOnFail;

    public MonitorActivityToolCapabilityHandler(boolean faultOnFail) {
        this.m_faultOnFail = faultOnFail;
    }

    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        try {
            BiBusHeader header = context.getBiBusHeader();
            boolean found = AuthenticatorFactory.getInstance().hasCapability(header, UserCapabilityEnum.canUseMonitorActivityTool);
            context.setCanUseMonitorActivityToolCapability(found);
            if (!found && this.m_faultOnFail) {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).debug("MonitorActivityToolCapabilityHandler.invoke(): Current user does not have the canUseMonitorActivityTool capablity.  User request has failed authentication.");
                throw new ProcessHandlerException(I18NCode.SEC_NO_PRIVELEDGES);
            }
        }
        catch (SDKClientException e) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).debug("MonitorActivityToolCapabilityHandler.invoke(): SDKClient Exception retrieving current session information for the user.");
            throw new ProcessHandlerException(I18NCode.IO_CM_COMMS_ERROR, (LocalizableException)((Object)e));
        }
        catch (EMFSecurityException e) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).debug("MonitorActivityToolCapabilityHandler.invoke(): Service Exception retrieving cached binding port.");
            throw new ProcessHandlerException(I18NCode.IO_CM_COMMS_ERROR);
        }
        catch (SDSServiceException e) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).debug("MonitorActivityToolCapabilityHandler.invoke(): Service Exception retrieving current session information for the user.");
            throw new ProcessHandlerException(I18NCode.IO_CM_COMMS_ERROR, (LocalizableException)((Object)e));
        }
    }
}

