/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.security;

import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;

public class UserAccountSecurityHandler
implements ProcessHandler {
    private PropEnum[] m_props = new PropEnum[]{PropEnum.searchPath, PropEnum.userName, PropEnum.defaultName};

    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        BiBusHeader header = context.getBiBusHeader();
        ContentManagerServiceClientPort cm = null;
        BaseClass[] classes = null;
        try {
            cm = Client.instance().getContentManagerServiceClient(new JobBiBusHeaders(header));
            classes = cm.query(new SearchPathMultipleObject("~"), this.m_props, new Sort[0], new QueryOptions());
            Account account = (Account)classes[0];
            context.setUserAccount(account);
        }
        catch (EMFSecurityException e) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("UserAccountSecurityHandler.invoke(): Service Exception retrieving cached binding port.");
            throw new ProcessHandlerException(I18NCode.IO_CM_COMMS_ERROR);
        }
        catch (SDKClientException e) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, (LocalizableException)((Object)e));
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("UserAccountSecurityHandler.invoke(): SDKClient Exception retrieving account information for the user.");
            throw new ProcessHandlerException(I18NCode.IO_CM_COMMS_ERROR, (LocalizableException)((Object)e));
        }
        catch (Throwable e) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("UserAccountSecurityHandler.invoke(): Error retrieving user account information.[" + e.getLocalizedMessage() + "]");
            throw new ProcessHandlerException(I18NCode.OTH_CM_ERROR);
        }
        finally {
            if (cm != null) {
                cm.close();
            }
        }
    }
}

