/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.util;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.jdbc.util.SqlResourceCloser;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.EventsContext;
import com.cognos.sds.handler.ProcessHandlerException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EventsUtil {
    private EventsUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List getTransientFutureEvents(EventsContext eventsContext) {
        ArrayList<Event> transientFutureEvents = new ArrayList<Event>();
        ArrayList<String> transientFutureEventPaths = new ArrayList<String>();
        JDBCConnection connection = null;
        Statement statement = null;
        ResultSet rs = null;
        List events = eventsContext.getEventList("FUTURE_EVENTS");
        if (events.size() == 0) {
            return Arrays.asList(new Object[0]);
        }
        try {
            StringBuffer sNID = new StringBuffer("'" + ((Event)events.get(0)).getEventId().getGuid() + "'");
            StringBuffer sFK_NCID = new StringBuffer(((Event)events.get(0)).getEventId().getTaskId().toString());
            for (int i = 1; i < events.size(); ++i) {
                sNID.append(", '" + ((Event)events.get(i)).getEventId().getGuid() + "'");
                sFK_NCID.append(", '" + ((Event)events.get(i)).getEventId().getTaskId().toString() + "'");
            }
            connection = NCConnection.instance().getConnectionFactory().createReadOnlyConnection();
            statement = connection.createStatement();
            rs = statement.executeQuery("SELECT rnn.NID, rnn.FK_NCID, nme.TEXT FROM R_NEWSITEMS_NCOBJECTS rnn, NC_MESSAGELINE_ELEMENT nme, R_MESSAGESTRUCT_TASK rmt where rnn.NID IN (" + sNID.toString() + ") and rnn.FK_NCID IN (" + sFK_NCID.toString() + ") and nme.FK_MESSAGESTRUCT_ID = rmt.FK_MESSAGESTRUCT_ID and rmt.FK_TASK_ID = rnn.FK_NCID and rnn.TYPE = 911 and nme.LINE_NO = 0");
            while (rs.next()) {
                for (Event event : events) {
                    if (event.getEventId().getGuid().compareTo(rs.getString(1)) != 0 || event.getEventId().getTaskId().toString().compareTo(Integer.toString(rs.getInt(2))) != 0) continue;
                    transientFutureEvents.add(event);
                    transientFutureEventPaths.add(EventsUtil.getPath(rs.getString(3)));
                }
            }
            if (connection == null) return Arrays.asList(transientFutureEvents, transientFutureEventPaths);
        }
        catch (SQLException e) {
            try {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("EventsUtil.getTransientFutureEvents(): Error retrieving schedule information.[" + e.getLocalizedMessage() + "]");
                ProcessHandlerException phe = new ProcessHandlerException(I18NCode.GEN_THROWABLE_ERROR, new String[]{e.getLocalizedMessage()});
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, (LocalizableException)((Object)phe));
                eventsContext.addUpdateEventFault(phe);
                if (connection == null) return Arrays.asList(transientFutureEvents, transientFutureEventPaths);
            }
            catch (Throwable throwable) {
                if (connection == null) throw throwable;
                SqlResourceCloser.closeResources(rs, statement);
                SqlResourceCloser.releaseConnection(connection);
                throw throwable;
            }
            SqlResourceCloser.closeResources(rs, statement);
            SqlResourceCloser.releaseConnection((JDBCConnection)connection);
            return Arrays.asList(transientFutureEvents, transientFutureEventPaths);
        }
        SqlResourceCloser.closeResources((ResultSet)rs, (Statement)statement);
        SqlResourceCloser.releaseConnection((JDBCConnection)connection);
        return Arrays.asList(transientFutureEvents, transientFutureEventPaths);
    }

    private static String getPath(String messageLine) {
        int startIdx = messageLine.indexOf("searchPathSingleObject") + 24;
        int endIdx = messageLine.indexOf("</objectPath>", startIdx);
        return messageLine.substring(startIdx, endIdx);
    }
}

