/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.util.SQL;

import com.cognos.sds.util.SQL.SQLJoin;
import com.cognos.sds.util.SQL.SQLOrQueryFilter;
import com.cognos.sds.util.SQL.SQLQueryFilter;
import com.cognos.sds.util.SQL.SQLSort;
import com.cognos.sds.util.SQL.SQLTableItem;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLQueryBuilder {
    private static final String DISTINCT = "DISTINCT ";
    private static final String SELECT = "SELECT ";
    private static final String FROM = " FROM ";
    private String[] m_supportedTables = null;
    private List m_selectedItems = new ArrayList();
    private Set m_selectedJoins = new TreeSet();
    private List<SQLQueryFilter> m_selectedFilters = new ArrayList<SQLQueryFilter>();
    private List m_selectedSorts = new ArrayList();
    private List m_groupBy = new ArrayList();
    private boolean m_useDistinct;

    public SQLQueryBuilder(String[] supportedTables) {
        this.m_supportedTables = supportedTables;
    }

    public void addSupportedJoin(SQLJoin join) {
        if (!this.isSupportedTable(join.getLHS().getTableName()) || !this.isSupportedTable(join.getRHS().getTableName())) {
            throw new IllegalStateException("table not supported by builder");
        }
        this.m_selectedJoins.add(join);
    }

    public void addSelectedItem(SQLTableItem item) {
        if (!this.isSupportedTable(item.getTableName())) {
            throw new IllegalStateException("table not supported by builder");
        }
        this.m_selectedItems.add(item);
    }

    public List getSelectedItems() {
        return this.m_selectedItems;
    }

    public List<SQLQueryFilter> getSelectedFilters() {
        return this.m_selectedFilters;
    }

    public void addGroupBy(SQLTableItem item) {
        if (!this.isSupportedTable(item.getTableName())) {
            throw new IllegalStateException("table not supported by builder");
        }
        this.m_groupBy.add(item);
    }

    public void addFilter(SQLQueryFilter filter) {
        if (!this.tablesSupported(filter.getFilterTables())) {
            throw new IllegalStateException("table not supported by builder");
        }
        this.m_selectedFilters.add(filter);
    }

    public void addOrFilter(SQLOrQueryFilter filter) {
        if (!this.tablesSupported(filter.getFilterTables())) {
            throw new IllegalStateException("table not supported by builder");
        }
        this.m_selectedFilters.add(filter);
    }

    public void addSort(SQLSort sort) {
        if (!this.isSupportedTable(sort.getSortTable())) {
            throw new IllegalStateException("table not supported by builder");
        }
        this.m_selectedSorts.add(sort);
    }

    public void reset() {
        this.m_selectedItems.clear();
        this.m_selectedFilters.clear();
        this.m_selectedSorts.clear();
        this.m_groupBy.clear();
    }

    public void setDistinct(boolean distinct) {
        this.m_useDistinct = distinct;
    }

    private boolean isSupportedTable(String tableName) {
        boolean isSupportedTable = false;
        int i = 0;
        while (i < this.m_supportedTables.length & !isSupportedTable) {
            if (this.m_supportedTables[i].equals(tableName)) {
                isSupportedTable = true;
            }
            ++i;
        }
        return isSupportedTable;
    }

    private boolean tablesSupported(String[] tableNames) {
        boolean tablesSupported = true;
        int i = 0;
        while (i < tableNames.length & tablesSupported) {
            tablesSupported = tablesSupported && this.isSupportedTable(tableNames[i]);
            ++i;
        }
        return tablesSupported;
    }

    public String getSQL() {
        return this.getSQL(null);
    }

    public String getSQL(Map<String, Object> params) {
        TreeSet<String> requiredTables = new TreeSet<String>();
        TreeSet requiredJoins = new TreeSet();
        for (SQLTableItem filter : this.m_selectedItems) {
            String itemTable = filter.getTableName();
            requiredTables.add(itemTable);
        }
        for (SQLQueryFilter filter : this.m_selectedFilters) {
            String[] filterTable = filter.getFilterTables();
            for (int iFilters = 0; iFilters < filterTable.length; ++iFilters) {
                requiredTables.add(filterTable[iFilters]);
            }
        }
        for (SQLSort sort : this.m_selectedSorts) {
            String sortTable = sort.getSortTable();
            requiredTables.add(sortTable);
        }
        String[] tableArray = requiredTables.toArray(new String[requiredTables.size()]);
        for (int i = 0; i < tableArray.length; ++i) {
            for (int j = 0; j < i; ++j) {
                List path;
                if (i == j || (path = this.findUndirectedPath(tableArray[i], tableArray[j])) == null) continue;
                for (SQLJoin join : path) {
                    requiredTables.add(join.getLHS().getTableName());
                    requiredTables.add(join.getRHS().getTableName());
                }
                requiredJoins.addAll(path);
            }
        }
        StringBuffer sqlBuffer = new StringBuffer(SELECT);
        if (this.m_useDistinct) {
            sqlBuffer.append(DISTINCT);
        }
        Iterator selectedItemsIter = this.m_selectedItems.iterator();
        while (selectedItemsIter.hasNext()) {
            sqlBuffer.append(selectedItemsIter.next().toString());
            if (!selectedItemsIter.hasNext()) continue;
            sqlBuffer.append(", ");
        }
        sqlBuffer.append(FROM);
        Iterator requiredTablesIter = requiredTables.iterator();
        while (requiredTablesIter.hasNext()) {
            sqlBuffer.append((String)requiredTablesIter.next());
            if (!requiredTablesIter.hasNext()) continue;
            sqlBuffer.append(", ");
        }
        if (requiredJoins.size() > 0 || this.m_selectedFilters.size() > 0) {
            sqlBuffer.append(" WHERE ");
        }
        Iterator requiredJoinsIter = requiredJoins.iterator();
        while (requiredJoinsIter.hasNext()) {
            sqlBuffer.append(requiredJoinsIter.next().toString());
            if (!requiredJoinsIter.hasNext()) continue;
            sqlBuffer.append(" AND ");
        }
        if (requiredJoins.size() > 0 && this.m_selectedFilters.size() > 0) {
            sqlBuffer.append(" AND ");
        }
        this.addFilterSql(sqlBuffer, params);
        if (this.m_selectedSorts.size() > 0) {
            sqlBuffer.append(" ORDER BY ");
            Iterator requiredSortIter = this.m_selectedSorts.iterator();
            while (requiredSortIter.hasNext()) {
                sqlBuffer.append(requiredSortIter.next().toString());
                if (!requiredSortIter.hasNext()) continue;
                sqlBuffer.append(", ");
            }
        }
        if (this.m_groupBy.size() > 0) {
            sqlBuffer.append(" GROUP BY ");
            Iterator groupByIter = this.m_groupBy.iterator();
            while (groupByIter.hasNext()) {
                sqlBuffer.append(groupByIter.next().toString());
                if (!groupByIter.hasNext()) continue;
                sqlBuffer.append(", ");
            }
        }
        return sqlBuffer.toString();
    }

    public void addFilterSql(StringBuffer sqlBuffer, Map<String, Object> params) {
        Iterator<SQLQueryFilter> requiredFilterConditionsIter = this.m_selectedFilters.iterator();
        while (requiredFilterConditionsIter.hasNext()) {
            sqlBuffer.append(requiredFilterConditionsIter.next().toString(params));
            if (!requiredFilterConditionsIter.hasNext()) continue;
            sqlBuffer.append(" AND ");
        }
    }

    public static void fillPreparedStatementParameters(Map<String, Object> params, List<String> orderedParamKeys, PreparedStatement preparedStatement) throws SQLException {
        for (int i = 0; i < orderedParamKeys.size(); ++i) {
            int parameterIndex = i + 1;
            String paramName = orderedParamKeys.get(i);
            Object param = params.get(paramName);
            if (param instanceof String) {
                preparedStatement.setString(parameterIndex, (String)param);
                continue;
            }
            if (param instanceof StringBuffer) {
                preparedStatement.setString(parameterIndex, ((StringBuffer)param).toString());
                continue;
            }
            if (param instanceof Long) {
                preparedStatement.setLong(parameterIndex, (Long)param);
                continue;
            }
            if (param instanceof Integer) {
                preparedStatement.setInt(parameterIndex, (Integer)param);
                continue;
            }
            throw new IllegalStateException("invalid filter type");
        }
    }

    public static String buildSQLAndCollectParams(String sql, HashMap<String, Object> params, List<String> orderedParams) {
        Pattern p = Pattern.compile("\\?[0-9]*\\?");
        Matcher m = p.matcher(sql);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String paramName = sql.substring(m.start(), m.end());
            m.appendReplacement(sb, "?");
            orderedParams.add(paramName);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private List findUndirectedPath(String startTableName, String endTableName) {
        LinkedList<SQLJoin> undirectedPath = new LinkedList<SQLJoin>();
        Set availableVertices = this.findVertices(this.m_selectedJoins);
        LinkedList directedPath = this.findPath(startTableName, endTableName, availableVertices);
        if (directedPath != null) {
            String[] vertexArray = directedPath.toArray(new String[directedPath.size()]);
            for (int i = 0; i < vertexArray.length - 1; ++i) {
                undirectedPath.addLast(this.findEdge(vertexArray[i], vertexArray[i + 1]));
            }
        }
        return undirectedPath;
    }

    private LinkedList findPath(String startTableName, String endTableName, Set availableVertices) {
        LinkedList queue = new LinkedList();
        LinkedList<String> path = new LinkedList<String>();
        path.addLast(startTableName);
        queue.addLast(path);
        availableVertices.remove(startTableName);
        while (queue.size() > 0) {
            LinkedList currentPath = (LinkedList)queue.removeFirst();
            String pathEnd = (String)currentPath.getLast();
            Set adjacentVertices = this.findAdjacentVertices(pathEnd, availableVertices);
            for (String adjacentVertex : adjacentVertices) {
                availableVertices.remove(adjacentVertex);
                LinkedList<String> newPath = new LinkedList<String>(currentPath);
                newPath.addLast(adjacentVertex);
                if (adjacentVertex.equals(endTableName)) {
                    return newPath;
                }
                queue.addLast(newPath);
            }
        }
        return null;
    }

    private SQLJoin findEdge(String startVertex, String endVertex) {
        for (SQLJoin join : this.m_selectedJoins) {
            if ((!join.getLHS().getTableName().equals(startVertex) || !join.getRHS().getTableName().equals(endVertex)) && (!join.getRHS().getTableName().equals(startVertex) || !join.getLHS().getTableName().equals(endVertex))) continue;
            return join;
        }
        return null;
    }

    private Set findAdjacentVertices(String startVertex, Set availableVertices) {
        TreeSet<String> adjacentVertices = new TreeSet<String>();
        for (String endVertex : availableVertices) {
            SQLJoin join = this.findEdge(startVertex, endVertex);
            if (join == null) continue;
            adjacentVertices.add(endVertex);
        }
        return adjacentVertices;
    }

    private Set findVertices(Set availableEdges) {
        TreeSet<String> vertices = new TreeSet<String>();
        for (SQLJoin join : availableEdges) {
            vertices.add(join.getLHS().getTableName());
            vertices.add(join.getRHS().getTableName());
        }
        return vertices;
    }
}

