/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.util.SQL;

import com.cognos.sds.util.SQL.SQLQueryFilter;
import com.cognos.sds.util.SQL.SQLTableItem;
import java.util.Map;

public class SQLQueryOperatorFilter
implements SQLQueryFilter {
    private SQLTableItem m_item;
    private Object[] m_condition;
    private FilterOperator m_filterOperator;

    public SQLQueryOperatorFilter(SQLTableItem item, FilterOperator operator) {
        this(item, null, operator);
    }

    public SQLQueryOperatorFilter(SQLTableItem item, Object condition, FilterOperator operator) {
        this(item, new Object[]{condition}, operator);
    }

    public SQLQueryOperatorFilter(SQLTableItem item, Object[] condition, FilterOperator operator) {
        this.m_item = item;
        this.m_condition = condition;
        this.m_filterOperator = operator;
    }

    @Override
    public String[] getFilterTables() {
        return new String[]{this.m_item.getTableName()};
    }

    public String getFilterColumn() {
        return this.m_item.getColumnName();
    }

    @Override
    public String toString(Map<String, Object> params) {
        String ret_value = null;
        if (this.m_filterOperator.equals(FilterOperator.BETWEEN)) {
            StringBuffer tmp = new StringBuffer(this.m_item.toString() + this.m_filterOperator.getOperator());
            this.append(tmp, this.m_condition[0], params);
            tmp.append(" AND ");
            this.append(tmp, this.m_condition[1], params);
        } else if (this.m_filterOperator.equals(FilterOperator.IN)) {
            StringBuffer tmp = new StringBuffer(this.m_item.toString() + this.m_filterOperator.getOperator() + "(");
            if (this.m_condition.length == 0) {
                this.append(tmp, "");
            } else {
                for (int i = 0; i < this.m_condition.length; ++i) {
                    this.append(tmp, this.m_condition[i], params);
                    if (i >= this.m_condition.length - 1) continue;
                    tmp.append(", ");
                }
            }
            tmp.append(")");
            ret_value = tmp.toString();
        } else if (this.m_filterOperator.equals(FilterOperator.IS_NULL)) {
            ret_value = this.m_item.toString() + this.m_filterOperator.getOperator();
        } else if (this.m_filterOperator.equals(FilterOperator.IS_NOT_NULL)) {
            ret_value = this.m_item.toString() + this.m_filterOperator.getOperator();
        } else {
            StringBuffer tmp = new StringBuffer(this.m_item.toString() + this.m_filterOperator.getOperator());
            this.append(tmp, this.m_condition[0], params);
            ret_value = tmp.toString();
        }
        return ret_value;
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    private void append(StringBuffer buffer, Object appendMe) {
        this.append(buffer, appendMe, null);
    }

    private void append(StringBuffer buffer, Object appendMe, Map<String, Object> params) {
        String paramName = null;
        if (params != null) {
            paramName = "?" + params.size() + "?";
        }
        if (appendMe instanceof String || appendMe instanceof StringBuffer) {
            if (params == null) {
                buffer.append("'" + appendMe.toString() + "'");
            } else {
                buffer.append(paramName);
                params.put(paramName, appendMe);
            }
        } else if (params == null) {
            buffer.append(appendMe.toString());
        } else {
            buffer.append(paramName);
            params.put(paramName, appendMe);
        }
    }

    public static class FilterOperator {
        public static FilterOperator EQUALS = new FilterOperator(" = ");
        public static FilterOperator NOT_EQUAL = new FilterOperator(" <> ");
        public static FilterOperator GREATER_THAN = new FilterOperator(" > ");
        public static FilterOperator LESS_THAN = new FilterOperator(" < ");
        public static FilterOperator GREATER_THAN_OR_EQUAL = new FilterOperator(" >= ");
        public static FilterOperator LESS_THAN_OR_EQUAL = new FilterOperator(" <= ");
        public static FilterOperator BETWEEN = new FilterOperator(" BETWEEN ");
        public static FilterOperator LIKE = new FilterOperator(" LIKE ");
        public static FilterOperator IN = new FilterOperator(" IN ");
        public static FilterOperator IS_NULL = new FilterOperator(" IS NULL ");
        public static FilterOperator IS_NOT_NULL = new FilterOperator(" IS NOT NULL ");
        private String m_operator;

        private FilterOperator(String operator) {
            this.m_operator = operator;
        }

        public String getOperator() {
            return this.m_operator;
        }

        public boolean equals(Object obj) {
            boolean ret_value = false;
            if (obj instanceof FilterOperator && this.m_operator.equals(((FilterOperator)obj).m_operator)) {
                ret_value = true;
            }
            return ret_value;
        }

        public int hashCode() {
            return this.m_operator.hashCode();
        }
    }
}

